/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guideeditor.widget.configurator;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.util.Position;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class ConfiguratorWidget<T>
extends WidgetGroup {
    protected T defaultValue;
    protected String name;
    protected boolean canDefault;
    protected boolean isDefault;
    protected JsonObject config;
    protected DraggableScrollableWidgetGroup group;
    private int nameWidth;
    private Consumer<String> onUpdated;

    public ConfiguratorWidget(DraggableScrollableWidgetGroup group, JsonObject config, String name) {
        this(group, config, name, null);
    }

    public ConfiguratorWidget(DraggableScrollableWidgetGroup group, JsonObject config, String name, T defaultValue) {
        super(new Position(5, group.getWidgetBottomHeight() + 5));
        this.group = group;
        this.defaultValue = defaultValue;
        this.name = name;
        this.canDefault = defaultValue != null;
        this.config = config;
        if (config.get(name) == null) {
            config.addProperty(name, (String)null);
        }
        if (this.canDefault && config.get(name).isJsonNull()) {
            this.isDefault = true;
        }
        this.addWidget(new LabelWidget(0, 4, name, -1).setShadow(true));
        if (ConfiguratorWidget.isClientSide()) {
            this.nameWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(name);
        }
        this.init();
    }

    protected void init() {
    }

    protected void updateValue(T value) {
        if (this.canDefault && this.isDefault) {
            return;
        }
        this.config.add(this.name, new Gson().toJsonTree(value));
        this.update();
    }

    public ConfiguratorWidget<T> setOnUpdated(Consumer<String> onUpdated) {
        this.onUpdated = onUpdated;
        return this;
    }

    protected void update() {
        if (this.onUpdated != null) {
            this.onUpdated.accept(this.name);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        if (this.canDefault && ConfiguratorWidget.isMouseOver(x + this.nameWidth + 4, y + 6, 5, 5, mouseX, mouseY)) {
            this.drawHoveringText(ItemStack.field_190927_a, Collections.singletonList(I18n.func_135052_a((String)"terminal.guide_editor.default", (Object[])new Object[0])), 100, mouseX, mouseY);
        }
        if (!this.isDefault) {
            super.drawInForeground(mouseX, mouseY);
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        ConfiguratorWidget.drawSolidRect(x, y, this.getSize().width, 1, -1);
        if (this.canDefault) {
            ConfiguratorWidget.drawBorder(x + this.nameWidth + 4, y + 6, 5, 5, -1, 1);
            if (this.isDefault) {
                ConfiguratorWidget.drawSolidRect(x + this.nameWidth + 5, y + 7, 3, 3, -1);
            }
        }
        if (this.canDefault && this.isDefault) {
            super.drawInBackground(-100, -100, partialTicks, context);
            ConfiguratorWidget.drawSolidRect(x, y + 15, this.getSize().width, this.getSize().height - 15, -1728053248);
        } else {
            super.drawInBackground(mouseX, mouseY, partialTicks, context);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        if (!this.isDefault && super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.canDefault && ConfiguratorWidget.isMouseOver(x + this.nameWidth + 4, y + 6, 5, 5, mouseX, mouseY)) {
            boolean bl = this.isDefault = !this.isDefault;
            if (this.isDefault) {
                this.config.addProperty(this.name, (String)null);
                this.update();
                this.onDefault();
            }
            ConfiguratorWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    protected void onDefault() {
    }
}

