/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guideeditor.widget.configurator;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextTexture;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.PhantomFluidWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.common.terminal.app.guide.widget.TankListWidget;
import gregtech.common.terminal.app.guideeditor.widget.configurator.ConfiguratorWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackConfigurator
extends ConfiguratorWidget<List<TankListWidget.FluidStackInfo>> {
    DraggableScrollableWidgetGroup container;
    List<TankListWidget.FluidStackInfo> tanks;

    public FluidStackConfigurator(DraggableScrollableWidgetGroup group, JsonObject config, String name) {
        super(group, config, name);
    }

    @Override
    protected void init() {
        this.container = new DraggableScrollableWidgetGroup(0, 27, 116, 100);
        this.addWidget(this.container);
        this.addWidget(new RectButtonWidget(0, 15, 116, 10, 1).setIcon(new TextTexture("terminal.guide_editor.add_slot", -1)).setClickListener(cd -> {
            this.addSlot(this.container, new TankListWidget.FluidStackInfo(null, 0));
            this.updateValue();
        }).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()));
        this.tanks = new ArrayList<TankListWidget.FluidStackInfo>();
        if (!this.config.get(this.name).isJsonNull()) {
            Gson gson = new Gson();
            for (JsonElement o : this.config.get(this.name).getAsJsonArray()) {
                this.addSlot(this.container, (TankListWidget.FluidStackInfo)gson.fromJson(o, TankListWidget.FluidStackInfo.class));
            }
        }
    }

    private void addSlot(DraggableScrollableWidgetGroup container, TankListWidget.FluidStackInfo fluidStackInfo) {
        WidgetGroup group = new WidgetGroup(0, this.tanks.size() * 20, 116, 20);
        this.tanks.add(fluidStackInfo);
        group.addWidget(new PhantomFluidWidget(1, 1, 18, 18, null, null).setBackgroundTexture(TerminalTheme.COLOR_B_2).setFluidStackSupplier(fluidStackInfo::getInstance, true).setFluidStackUpdater(fluidStack -> {
            fluidStackInfo.update((FluidStack)fluidStack);
            this.updateValue();
        }, true));
        group.addWidget(new RectButtonWidget(20, 0, 20, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(data -> {
            fluidStackInfo.amount = Math.max(0, fluidStackInfo.amount - (data.isShiftClick ? (data.isCtrlClick ? 1000 : 10) : (data.isCtrlClick ? 100 : 1)));
            this.updateValue();
        }).setHoverText("Shift -10|Ctrl -100|Shift+Ctrl -1000").setIcon(new TextTexture("-1", -1)));
        group.addWidget(new RectButtonWidget(76, 0, 20, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(data -> {
            fluidStackInfo.amount = Math.max(0, fluidStackInfo.amount + (data.isShiftClick ? (data.isCtrlClick ? 1000 : 10) : (data.isCtrlClick ? 100 : 1)));
            this.updateValue();
        }).setHoverText("Shift +10|Ctrl +100|Shift+Ctrl +1000").setIcon(new TextTexture("+1", -1)));
        group.addWidget(new ImageWidget(40, 0, 36, 20, TerminalTheme.COLOR_B_2));
        group.addWidget(new SimpleTextWidget(58, 10, "", 0xFFFFFF, () -> Integer.toString(fluidStackInfo.amount), true));
        group.addWidget(new RectButtonWidget(96, 0, 20, 20).setColors(TerminalTheme.COLOR_B_1.getColor(), TerminalTheme.COLOR_1.getColor(), TerminalTheme.COLOR_B_1.getColor()).setClickListener(data -> {
            container.waitToRemoved(group);
            this.tanks.remove(fluidStackInfo);
            int index = container.widgets.indexOf(group);
            for (int i = container.widgets.size() - 1; i > index; --i) {
                ((Widget)container.widgets.get(i)).addSelfPosition(0, -20);
            }
            this.updateValue();
        }).setIcon(GuiTextures.ICON_REMOVE));
        container.addWidget(group);
    }

    private void updateValue() {
        this.updateValue(this.tanks);
    }
}

