/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.hardware;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.impl.ElectricItem;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.terminal.hardware.IHardwareCapability;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;

public class BatteryHardware
extends Hardware
implements IElectricItem,
IHardwareCapability {
    protected final List<BiConsumer<ItemStack, Long>> listeners = new ArrayList<BiConsumer<ItemStack, Long>>();

    @Override
    public boolean isHardwareAdequate(Hardware demand) {
        return demand instanceof BatteryHardware && ((BatteryHardware)demand).getTier() <= this.getTier() && this.getCharge() > 0L;
    }

    @Override
    public String addInformation() {
        return GTValues.VN[this.getTier()];
    }

    @Override
    public Hardware createHardware(ItemStack itemStack) {
        return new BatteryHardware();
    }

    @Override
    public NBTTagCompound acceptItemStack(ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null || !electricItem.canProvideChargeExternally() || !electricItem.chargeable()) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("maxCharge", electricItem.getMaxCharge());
        nbt.func_74772_a("charge", electricItem.getCharge());
        nbt.func_74768_a("tier", electricItem.getTier());
        return nbt;
    }

    @Override
    public String getRegistryName() {
        return "battery";
    }

    @Override
    public IGuiTexture getIcon() {
        if (!this.hasHW()) {
            return super.getIcon();
        }
        return new ItemStackTexture(this.isCreative() ? MetaItems.ULTIMATE_BATTERY.getInfiniteChargedStack() : this.getItem(), new ItemStack[0]);
    }

    @Override
    public void addChargeListener(BiConsumer<ItemStack, Long> chargeListener) {
        this.listeners.add(chargeListener);
    }

    public void setCharge(long change) {
        this.getNBT().func_74772_a("charge", change);
        this.listeners.forEach(l -> l.accept(this.provider.getItemStack(), change));
    }

    @Override
    public long getTransferLimit() {
        return GTValues.V[this.getTier()];
    }

    @Override
    public long getMaxCharge() {
        return this.isCreative() ? Long.MAX_VALUE : this.getNBT().func_74763_f("maxCharge");
    }

    @Override
    public long getCharge() {
        return this.isCreative() ? Long.MAX_VALUE : this.getNBT().func_74763_f("charge");
    }

    @Override
    public boolean canProvideChargeExternally() {
        return false;
    }

    @Override
    public boolean chargeable() {
        return true;
    }

    @Override
    public long charge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean simulate) {
        if (this.provider.getItemStack().func_190916_E() != 1) {
            return 0L;
        }
        if (chargerTier >= this.getTier() && amount > 0L) {
            long canReceive = this.getMaxCharge() - this.getCharge();
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, this.getTransferLimit());
            }
            long charged = Math.min(amount, canReceive);
            if (!simulate) {
                this.setCharge(this.getCharge() + charged);
            }
            return charged;
        }
        return 0L;
    }

    @Override
    public long discharge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (this.provider.getItemStack().func_190916_E() != 1) {
            return 0L;
        }
        if (!(externally && amount != Long.MAX_VALUE || chargerTier < this.getTier() || amount <= 0L)) {
            if (!ignoreTransferLimit) {
                amount = Math.min(amount, this.getTransferLimit());
            }
            long charge = this.getCharge();
            long discharged = Math.min(amount, charge);
            if (!simulate) {
                this.setCharge(charge - discharged);
            }
            return discharged;
        }
        return 0L;
    }

    @Override
    public int getTier() {
        return this.isCreative() ? GTValues.V.length - 1 : this.getNBT().func_74762_e("tier");
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability) {
        return capability == GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability) {
        return (T)(capability == GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM ? GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM.cast((Object)this) : null);
    }

    @Override
    public ItemStack onHardwareRemoved(ItemStack itemStack) {
        IElectricItem item = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item instanceof ElectricItem) {
            ((ElectricItem)item).setCharge(this.getCharge());
        }
        return itemStack;
    }

    public static class BatteryDemand
    extends BatteryHardware {
        public final int tier;
        public final long cost;

        public BatteryDemand(int tier, long cost) {
            this.tier = tier;
            this.cost = cost;
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public long getCharge() {
            return this.getCost();
        }

        public long getCost() {
            return this.cost;
        }
    }
}

