/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import gregtech.api.items.behavior.MonitorPluginBaseBehavior;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.network.IPacket;
import gregtech.api.network.IServerExecutor;
import gregtech.common.metatileentities.multi.electric.centralmonitor.MetaTileEntityMonitorScreen;
import gregtech.core.network.NetworkUtils;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class PacketPluginSynced
implements IPacket,
IServerExecutor {
    private int dimension;
    private BlockPos pos;
    private int id;
    private PacketBuffer updateData;

    public PacketPluginSynced(int dimension, BlockPos pos, int id, PacketBuffer updateData) {
        this.dimension = dimension;
        this.pos = pos;
        this.id = id;
        this.updateData = updateData;
    }

    @Override
    public void encode(PacketBuffer buf) {
        NetworkUtils.writePacketBuffer(buf, this.updateData);
        buf.func_150787_b(this.dimension);
        buf.func_179255_a(this.pos);
        buf.func_150787_b(this.id);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.updateData = NetworkUtils.readPacketBuffer(buf);
        this.dimension = buf.func_150792_a();
        this.pos = buf.func_179259_c();
        this.id = buf.func_150792_a();
    }

    @Override
    public void executeServer(NetHandlerPlayServer handler) {
        MonitorPluginBaseBehavior plugin;
        TileEntity te = NetworkUtils.getTileEntityServer(this.dimension, this.pos);
        if (te instanceof IGregTechTileEntity && ((IGregTechTileEntity)te).getMetaTileEntity() instanceof MetaTileEntityMonitorScreen && (plugin = ((MetaTileEntityMonitorScreen)((IGregTechTileEntity)te).getMetaTileEntity()).plugin) != null) {
            plugin.readPluginAction(handler.field_147369_b, this.id, this.updateData);
        }
    }

    public PacketPluginSynced() {
    }
}

