/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.network.IPacket;
import gregtech.api.network.IServerExecutor;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PacketRecoverMTE
implements IPacket,
IServerExecutor {
    private int dimension;
    private BlockPos pos;

    public PacketRecoverMTE(int dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_150787_b(this.dimension);
        buf.func_179255_a(this.pos);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.dimension = buf.func_150792_a();
        this.pos = buf.func_179259_c();
    }

    @Override
    public void executeServer(NetHandlerPlayServer handler) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimension);
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof IGregTechTileEntity && ((IGregTechTileEntity)te).isValid()) {
            IGregTechTileEntity holder = (IGregTechTileEntity)te;
            holder.writeCustomData(-1, buffer -> {
                buffer.func_150787_b(GregTechAPI.MTE_REGISTRY.getIdByObjectName(holder.getMetaTileEntity().metaTileEntityId));
                holder.getMetaTileEntity().writeInitialSyncData((PacketBuffer)buffer);
            });
        } else if (!(world.func_180495_p(this.pos).func_177230_c() instanceof BlockMachine)) {
            handler.field_147369_b.field_71135_a.func_147359_a((Packet)new SPacketBlockChange((World)world, this.pos));
        }
    }

    public PacketRecoverMTE() {
    }
}

