/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import gregtech.api.GregTechAPI;
import gregtech.api.gui.UIFactory;
import gregtech.api.network.IClientExecutor;
import gregtech.api.network.IPacket;
import gregtech.api.util.GTLog;
import gregtech.core.network.NetworkUtils;
import gregtech.core.network.packets.PacketUIWidgetUpdate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketUIOpen
implements IPacket,
IClientExecutor {
    private int uiFactoryId;
    private PacketBuffer serializedHolder;
    private int windowId;
    private List<PacketUIWidgetUpdate> initialWidgetUpdates;

    public PacketUIOpen(int uiFactoryId, PacketBuffer serializedHolder, int windowId, List<PacketUIWidgetUpdate> initialWidgetUpdates) {
        this.uiFactoryId = uiFactoryId;
        this.serializedHolder = serializedHolder;
        this.windowId = windowId;
        this.initialWidgetUpdates = initialWidgetUpdates;
    }

    @Override
    public void encode(PacketBuffer buf) {
        NetworkUtils.writePacketBuffer(buf, this.serializedHolder);
        buf.func_150787_b(this.uiFactoryId);
        buf.func_150787_b(this.windowId);
        buf.func_150787_b(this.initialWidgetUpdates.size());
        for (PacketUIWidgetUpdate packet : this.initialWidgetUpdates) {
            packet.encode(buf);
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.serializedHolder = NetworkUtils.readPacketBuffer(buf);
        this.uiFactoryId = buf.func_150792_a();
        this.windowId = buf.func_150792_a();
        this.initialWidgetUpdates = new ArrayList<PacketUIWidgetUpdate>();
        int packetsToRead = buf.func_150792_a();
        for (int i = 0; i < packetsToRead; ++i) {
            PacketUIWidgetUpdate packet = new PacketUIWidgetUpdate();
            packet.decode(buf);
            this.initialWidgetUpdates.add(packet);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(NetHandlerPlayClient handler) {
        UIFactory uiFactory = GregTechAPI.UI_FACTORY_REGISTRY.getObjectById(this.uiFactoryId);
        if (uiFactory == null) {
            GTLog.logger.warn("Couldn't find UI Factory with id '{}'", (Object)this.uiFactoryId);
        } else {
            uiFactory.initClientUI(this.serializedHolder, this.windowId, this.initialWidgetUpdates);
        }
    }

    public PacketUIOpen() {
    }
}

