/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IMultipleRecipeMaps;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.recipes.machines.RecipeMapFurnace;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.BedrockFluidDepositDefinition;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.gui.widget.craftingstation.CraftingSlotWidget;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.basic.GTFluidVeinCategory;
import gregtech.integration.jei.basic.GTFluidVeinInfo;
import gregtech.integration.jei.basic.GTOreCategory;
import gregtech.integration.jei.basic.GTOreInfo;
import gregtech.integration.jei.basic.MaterialTree;
import gregtech.integration.jei.basic.MaterialTreeCategory;
import gregtech.integration.jei.basic.OreByProduct;
import gregtech.integration.jei.basic.OreByProductCategory;
import gregtech.integration.jei.multiblock.MultiblockInfoCategory;
import gregtech.integration.jei.recipe.FacadeRegistryPlugin;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import gregtech.integration.jei.recipe.IntCircuitCategory;
import gregtech.integration.jei.recipe.IntCircuitRecipeWrapper;
import gregtech.integration.jei.recipe.RecipeMapCategory;
import gregtech.integration.jei.utils.MachineSubtypeHandler;
import gregtech.integration.jei.utils.MetaItemSubtypeHandler;
import gregtech.integration.jei.utils.ModularUIGuiHandler;
import gregtech.integration.jei.utils.MultiblockInfoRecipeFocusShower;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.Internal;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.input.InputHandler;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@JEIPlugin
public class GTJeiPlugin
implements IModPlugin {
    public static IIngredientRegistry ingredientRegistry;
    public static IJeiRuntime jeiRuntime;
    public static IGuiHelper guiHelper;

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        GTJeiPlugin.jeiRuntime = jeiRuntime;
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
        MetaItemSubtypeHandler subtype = new MetaItemSubtypeHandler();
        for (MetaItem<?> metaItem : MetaItems.ITEMS) {
            subtypeRegistry.registerSubtypeInterpreter(metaItem, (ISubtypeRegistry.ISubtypeInterpreter)subtype);
        }
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)MetaBlocks.MACHINE), (ISubtypeRegistry.ISubtypeInterpreter)new MachineSubtypeHandler());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new IntCircuitCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockInfoCategory(registry.getJeiHelpers())});
        for (RecipeMap<?> recipeMap : RecipeMap.getRecipeMaps()) {
            if (recipeMap.isHidden) continue;
            registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapCategory(recipeMap, registry.getJeiHelpers().getGuiHelper())});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new OreByProductCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new GTOreCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new GTFluidVeinCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MaterialTreeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void register(IModRegistry registry) {
        MetaTileEntity[][] machineLists;
        Object metaTileEntity;
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipes(IntCircuitRecipeWrapper.create(), IntCircuitCategory.UID);
        MultiblockInfoCategory.registerRecipes(registry);
        registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)new FacadeRegistryPlugin());
        ModularUIGuiHandler modularUIGuiHandler = new ModularUIGuiHandler(jeiHelpers.recipeTransferHandlerHelper());
        modularUIGuiHandler.setValidHandlers(widget -> !(widget instanceof CraftingSlotWidget));
        if (Loader.isModLoaded((String)"jei")) {
            modularUIGuiHandler.setValidHandlers(widget -> !(widget instanceof CraftingSlotWidget) && widget instanceof ICraftingRecipeWrapper);
        }
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)modularUIGuiHandler, "universal recipe transfer handler");
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{modularUIGuiHandler});
        registry.addGhostIngredientHandler(modularUIGuiHandler.getGuiContainerClass(), (IGhostIngredientHandler)modularUIGuiHandler);
        ModularUIGuiHandler craftingStationGuiHandler = new ModularUIGuiHandler(jeiHelpers.recipeTransferHandlerHelper());
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)craftingStationGuiHandler, "minecraft.crafting");
        for (RecipeMap<?> recipeMap : RecipeMap.getRecipeMaps()) {
            if (recipeMap.isHidden) continue;
            Stream<Recipe> recipeStream = recipeMap.getRecipeList().stream().filter(recipe -> !recipe.isHidden() && recipe.hasValidInputsForDisplay());
            if (recipeMap.getSmallRecipeMap() != null) {
                Collection<Recipe> smallRecipes = recipeMap.getSmallRecipeMap().getRecipeList();
                recipeStream = recipeStream.filter(recipe -> !smallRecipes.contains(recipe));
            }
            registry.addRecipes((Collection)recipeStream.map(r -> new GTRecipeWrapper(recipeMap, (Recipe)r)).collect(Collectors.toList()), "gregtech:" + recipeMap.unlocalizedName);
        }
        for (ResourceLocation metaTileEntityId : GregTechAPI.MTE_REGISTRY.func_148742_b()) {
            IControllable workableCapability;
            metaTileEntity = (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_82594_a(metaTileEntityId);
            assert (metaTileEntity != null);
            if (((MetaTileEntity)metaTileEntity).getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null) == null || !((workableCapability = ((MetaTileEntity)metaTileEntity).getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null)) instanceof AbstractRecipeLogic)) continue;
            MetaTileEntity[][] logic = (MetaTileEntity[][])workableCapability;
            if (metaTileEntity instanceof IMultipleRecipeMaps) {
                RecipeMap<?>[] recipeMapArray = ((IMultipleRecipeMaps)metaTileEntity).getAvailableRecipeMaps();
                int n = recipeMapArray.length;
                for (int i = 0; i < n; ++i) {
                    RecipeMap<?> recipeMap = recipeMapArray[i];
                    GTJeiPlugin.registerRecipeMapCatalyst(registry, recipeMap, (MetaTileEntity)metaTileEntity);
                }
                continue;
            }
            if (logic.getRecipeMap() == null) continue;
            GTJeiPlugin.registerRecipeMapCatalyst(registry, logic.getRecipeMap(), (MetaTileEntity)metaTileEntity);
        }
        String semiFluidMapId = "gregtech:" + RecipeMaps.SEMI_FLUID_GENERATOR_FUELS.getUnlocalizedName();
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_BRONZE_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_STEEL_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_TITANIUM_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_TUNGSTENSTEEL_BOILER.getStackForm(), new String[]{semiFluidMapId});
        CopyOnWriteArrayList<OreByProduct> oreByproductList = new CopyOnWriteArrayList<OreByProduct>();
        metaTileEntity = GregTechAPI.MATERIAL_REGISTRY.iterator();
        while (metaTileEntity.hasNext()) {
            Material material = (Material)metaTileEntity.next();
            if (!material.hasProperty(PropertyKey.ORE)) continue;
            oreByproductList.add(new OreByProduct(material));
        }
        String oreByProductId = "gregtech:ore_by_product";
        registry.addRecipes(oreByproductList, oreByProductId);
        for (MetaTileEntity[] machine : machineLists = new MetaTileEntity[][]{MetaTileEntities.MACERATOR, MetaTileEntities.ORE_WASHER, MetaTileEntities.CENTRIFUGE, MetaTileEntities.THERMAL_CENTRIFUGE, MetaTileEntities.CHEMICAL_BATH, MetaTileEntities.ELECTROMAGNETIC_SEPARATOR, MetaTileEntities.SIFTER}) {
            if (machine.length < 2 || machine[1] == null) continue;
            registry.addRecipeCatalyst((Object)machine[1].getStackForm(), new String[]{oreByProductId});
        }
        CopyOnWriteArrayList<MaterialTree> materialTreeList = new CopyOnWriteArrayList<MaterialTree>();
        Iterator iterator = GregTechAPI.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material = (Material)iterator.next();
            if (!material.hasProperty(PropertyKey.DUST)) continue;
            materialTreeList.add(new MaterialTree(material));
        }
        registry.addRecipes(materialTreeList, "gregtech:material_tree");
        List<OreDepositDefinition> oreVeins = WorldGenRegistry.getOreDeposits();
        CopyOnWriteArrayList<GTOreInfo> oreInfoList = new CopyOnWriteArrayList<GTOreInfo>();
        for (OreDepositDefinition vein : oreVeins) {
            oreInfoList.add(new GTOreInfo(vein));
        }
        String oreSpawnID = "gregtech:ore_spawn_location";
        registry.addRecipes(oreInfoList, oreSpawnID);
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_LV.getStackForm(), new String[]{oreSpawnID});
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_HV.getStackForm(), new String[]{oreSpawnID});
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_LUV.getStackForm(), new String[]{oreSpawnID});
        List<BedrockFluidDepositDefinition> fluidVeins = WorldGenRegistry.getBedrockVeinDeposits();
        CopyOnWriteArrayList<GTFluidVeinInfo> fluidVeinInfos = new CopyOnWriteArrayList<GTFluidVeinInfo>();
        for (BedrockFluidDepositDefinition fluidVein : fluidVeins) {
            fluidVeinInfos.add(new GTFluidVeinInfo(fluidVein));
        }
        String fluidVeinSpawnID = "gregtech:fluid_spawn_location";
        registry.addRecipes(fluidVeinInfos, fluidVeinSpawnID);
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_HV.getStackForm(), new String[]{fluidVeinSpawnID});
        registry.addRecipeCatalyst((Object)MetaItems.PROSPECTOR_LUV.getStackForm(), new String[]{fluidVeinSpawnID});
        ingredientRegistry = registry.getIngredientRegistry();
        for (int i = 0; i <= 32; ++i) {
            registry.addIngredientInfo((Object)IntCircuitIngredient.getIntegratedCircuit(i), VanillaTypes.ITEM, new String[]{"metaitem.circuit.integrated.jei_description"});
        }
        registry.addRecipeCatalyst((Object)MetaTileEntities.WORKBENCH.getStackForm(), new String[]{"minecraft.crafting"});
        for (SimpleMachineMetaTileEntity machine : MetaTileEntities.CANNER) {
            if (machine == null) continue;
            registry.addIngredientInfo((Object)machine.getStackForm(), VanillaTypes.ITEM, new String[]{"gregtech.machine.canner.jei_description"});
        }
        MultiblockInfoCategory.REGISTER.forEach(mte -> {
            String[] desc = mte.getDescription();
            if (desc.length > 0) {
                registry.addIngredientInfo((Object)mte.getStackForm(), VanillaTypes.ITEM, mte.getDescription());
            }
        });
        registry.addIngredientInfo((Object)new ItemStack((Block)MetaBlocks.BRITTLE_CHARCOAL), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"tile.brittle_charcoal.tooltip.1", (Object[])new Object[]{I18n.func_135052_a((String)"tile.brittle_charcoal.tooltip.2", (Object[])new Object[0])})});
    }

    public static void setupInputHandler() {
        try {
            Field inputHandlerField = Internal.class.getDeclaredField("inputHandler");
            inputHandlerField.setAccessible(true);
            InputHandler inputHandler = (InputHandler)inputHandlerField.get(null);
            List showsRecipeFocuses = (List)ObfuscationReflectionHelper.getPrivateValue(InputHandler.class, (Object)inputHandler, (String)"showsRecipeFocuses");
            showsRecipeFocuses.add(new MultiblockInfoRecipeFocusShower());
        }
        catch (Exception e) {
            GTLog.logger.error("Could not reflect JEI Internal inputHandler", (Throwable)e);
        }
    }

    private static void registerRecipeMapCatalyst(IModRegistry registry, RecipeMap<?> recipeMap, MetaTileEntity metaTileEntity) {
        registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"gregtech:" + recipeMap.unlocalizedName});
        if (recipeMap instanceof RecipeMapFurnace) {
            registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"minecraft.smelting"});
            return;
        }
        if (recipeMap.getSmallRecipeMap() != null) {
            registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"gregtech:" + recipeMap.getSmallRecipeMap().unlocalizedName});
            return;
        }
        RecipeMapCategory category = RecipeMapCategory.getCategoryMap().get(recipeMap);
        if (category != null && !(metaTileEntity instanceof SteamMetaTileEntity)) {
            category.setIcon(metaTileEntity.getStackForm());
        }
    }
}

