/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.basic;

import gregtech.api.gui.GuiTextures;
import gregtech.api.util.GTJEIUtility;
import gregtech.api.util.GTStringUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.worldgen.config.BedrockFluidDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.integration.jei.basic.BasicRecipeCategory;
import gregtech.integration.jei.basic.GTFluidVeinInfo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GTFluidVeinCategory
extends BasicRecipeCategory<GTFluidVeinInfo, GTFluidVeinInfo> {
    protected final IDrawable slot;
    private BedrockFluidDepositDefinition definition;
    private String veinName;
    private int weight;
    private int[] yields;
    private int depletionAmount;
    private int depletionChance;
    private int depletedYield;
    private final int SLOT_CENTER = 79;
    protected final Map<Integer, String> namedDimensions = WorldGenRegistry.getNamedDimensions();
    private Supplier<List<Integer>> dimensions;
    private final int textStartX = 5;
    private int weightLength;
    private int minYieldLength;
    private int maxYieldLength;
    private int depletionChanceLength;
    private int depletionAmountLength;
    private int depletedYieldLength;
    private final int startPosY = 40;

    public GTFluidVeinCategory(IGuiHelper guiHelper) {
        super("fluid_spawn_location", "fluid.spawnlocation.name", (IDrawable)guiHelper.createBlankDrawable(176, 166), guiHelper);
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, GTFluidVeinInfo gtFluidVeinInfo, @Nonnull IIngredients ingredients) {
        IGuiFluidStackGroup fluidStackGroup = recipeLayout.getFluidStacks();
        fluidStackGroup.init(0, true, 79, 19, 16, 16, 1, false, null);
        fluidStackGroup.addTooltipCallback(gtFluidVeinInfo::addTooltip);
        fluidStackGroup.set(ingredients);
        this.definition = gtFluidVeinInfo.getDefinition();
        this.veinName = gtFluidVeinInfo.getName();
        this.weight = gtFluidVeinInfo.getWeight();
        this.yields = gtFluidVeinInfo.getYields();
        this.depletionAmount = gtFluidVeinInfo.getDepletionAmount();
        this.depletionChance = gtFluidVeinInfo.getDepletionChance();
        this.depletedYield = gtFluidVeinInfo.getDepletedYield();
        this.dimensions = GTUtility.getAllRegisteredDimensions(this.definition.getDimensionFilter());
        GTJEIUtility.cleanupDimensionList(this.dimensions);
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull GTFluidVeinInfo gtFluidVeinInfo) {
        return gtFluidVeinInfo;
    }

    @Override
    public void drawExtras(@Nonnull Minecraft minecraft) {
        GTStringUtils.drawCenteredStringWithCutoff(this.veinName, minecraft.field_71466_p, 176);
        this.slot.draw(minecraft, 78, 18);
        String veinWeight = I18n.func_135052_a((String)"gregtech.jei.fluid.vein_weight", (Object[])new Object[]{this.weight});
        this.weightLength = minecraft.field_71466_p.func_78256_a(veinWeight);
        minecraft.field_71466_p.func_78276_b(veinWeight, 5, 40, 0x111111);
        String veinMinYield = I18n.func_135052_a((String)"gregtech.jei.fluid.min_yield", (Object[])new Object[]{this.yields[0]});
        this.minYieldLength = minecraft.field_71466_p.func_78256_a(veinMinYield);
        minecraft.field_71466_p.func_78276_b(veinMinYield, 5, 40 + this.FONT_HEIGHT + 1, 0x111111);
        String veinMaxYield = I18n.func_135052_a((String)"gregtech.jei.fluid.max_yield", (Object[])new Object[]{this.yields[1]});
        this.maxYieldLength = minecraft.field_71466_p.func_78256_a(veinMaxYield);
        minecraft.field_71466_p.func_78276_b(veinMaxYield, 5, 40 + 2 * this.FONT_HEIGHT + 1, 0x111111);
        String veinDepletionChance = I18n.func_135052_a((String)"gregtech.jei.fluid.depletion_chance", (Object[])new Object[]{this.depletionChance});
        this.depletionChanceLength = minecraft.field_71466_p.func_78256_a(veinDepletionChance);
        minecraft.field_71466_p.func_78276_b(veinDepletionChance, 5, 40 + 3 * this.FONT_HEIGHT + 1, 0x111111);
        String veinDepletionAmount = I18n.func_135052_a((String)"gregtech.jei.fluid.depletion_amount", (Object[])new Object[]{this.depletionAmount});
        this.depletionAmountLength = minecraft.field_71466_p.func_78256_a(veinDepletionAmount);
        minecraft.field_71466_p.func_78276_b(veinDepletionAmount, 5, 40 + 4 * this.FONT_HEIGHT + 1, 0x111111);
        String veinDepletedYield = I18n.func_135052_a((String)"gregtech.jei.fluid.depleted_rate", (Object[])new Object[]{this.depletedYield});
        this.depletedYieldLength = minecraft.field_71466_p.func_78256_a(veinDepletedYield);
        minecraft.field_71466_p.func_78276_b(veinDepletedYield, 5, 40 + 5 * this.FONT_HEIGHT + 1, 0x111111);
        String veinDimension = I18n.func_135052_a((String)"gregtech.jei.fluid.dimension", (Object[])new Object[0]) + " ";
        int dimensionLength = minecraft.field_71466_p.func_78256_a(veinDimension);
        minecraft.field_71466_p.func_78276_b(veinDimension, 5, 40 + 6 * this.FONT_HEIGHT + 1, 0x111111);
        GTJEIUtility.drawMultiLineCommaSeparatedDimensionList(this.namedDimensions, this.dimensions.get(), minecraft.field_71466_p, 5, 40 + 6 * this.FONT_HEIGHT + 1, 5 + dimensionLength);
    }

    @Override
    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (GTUtility.isPointWithinRange(5, 40, this.weightLength, this.FONT_HEIGHT, mouseX, mouseY)) {
            return Collections.singletonList(I18n.func_135052_a((String)"gregtech.jei.fluid.weight_hover", (Object[])new Object[0]));
        }
        if (GTUtility.isPointWithinRange(5, 40 + this.FONT_HEIGHT + 1, this.minYieldLength, this.FONT_HEIGHT + 1, mouseX, mouseY)) {
            return Collections.singletonList(I18n.func_135052_a((String)"gregtech.jei.fluid.min_hover", (Object[])new Object[0]));
        }
        if (GTUtility.isPointWithinRange(5, 40 + 2 * this.FONT_HEIGHT + 1, this.maxYieldLength, this.FONT_HEIGHT + 1, mouseX, mouseY)) {
            return Collections.singletonList(I18n.func_135052_a((String)"gregtech.jei.fluid.max_hover", (Object[])new Object[0]));
        }
        if (GTUtility.isPointWithinRange(5, 40 + 3 * this.FONT_HEIGHT + 1, this.depletionChanceLength, this.FONT_HEIGHT + 1, mouseX, mouseY)) {
            return Collections.singletonList(I18n.func_135052_a((String)"gregtech.jei.fluid.dep_chance_hover", (Object[])new Object[0]));
        }
        if (GTUtility.isPointWithinRange(5, 40 + 4 * this.FONT_HEIGHT + 1, this.depletionAmountLength, this.FONT_HEIGHT + 1, mouseX, mouseY)) {
            return Collections.singletonList(I18n.func_135052_a((String)"gregtech.jei.fluid.dep_amount_hover", (Object[])new Object[0]));
        }
        if (GTUtility.isPointWithinRange(5, 40 + 5 * this.FONT_HEIGHT + 1, this.depletedYieldLength, this.FONT_HEIGHT + 1, mouseX, mouseY)) {
            return Collections.singletonList(I18n.func_135052_a((String)"gregtech.jei.fluid.dep_yield_hover", (Object[])new Object[0]));
        }
        return Collections.emptyList();
    }
}

