/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.basic;

import gregtech.api.util.FileUtility;
import gregtech.api.util.GTJEIUtility;
import gregtech.api.worldgen.config.BedrockFluidDepositDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class GTFluidVeinInfo
implements IRecipeWrapper {
    private final BedrockFluidDepositDefinition definition;
    private String name;
    private final String description;
    private final int weight;
    private final int[] yields;
    private final int depletionAmount;
    private final int depletionChance;
    private final int depletedYield;
    private final FluidStack fluid;
    private final Function<Biome, Integer> biomeFunction;
    private final List<List<FluidStack>> fluidList = new ArrayList<List<FluidStack>>();
    private final List<List<ItemStack>> bucketList = new ArrayList<List<ItemStack>>();

    public GTFluidVeinInfo(BedrockFluidDepositDefinition definition) {
        this.definition = definition;
        this.name = definition.getAssignedName();
        if (this.name == null) {
            this.name = FileUtility.trimFileName(definition.getDepositName());
        }
        this.description = definition.getDescription();
        this.weight = definition.getWeight();
        this.yields = definition.getYields();
        this.depletionAmount = definition.getDepletionAmount();
        this.depletionChance = definition.getDepletionChance();
        this.depletedYield = definition.getDepletedYield();
        this.fluid = new FluidStack(definition.getStoredFluid(), 1);
        ArrayList<FluidStack> fluidList2 = new ArrayList<FluidStack>();
        fluidList2.add(this.fluid);
        this.fluidList.add(fluidList2);
        this.biomeFunction = definition.getBiomeWeightModifier();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, this.fluidList);
        ingredients.setOutputLists(VanillaTypes.FLUID, this.fluidList);
        ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)this.fluid);
        if (!bucket.func_190926_b()) {
            this.bucketList.add(Collections.singletonList(bucket));
            ingredients.setInputLists(VanillaTypes.ITEM, this.bucketList);
            ingredients.setOutputLists(VanillaTypes.ITEM, this.bucketList);
        }
    }

    public void addTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        List<String> biomeTooltip;
        if (this.description != null) {
            tooltip.add(this.description);
        }
        if (!(biomeTooltip = GTJEIUtility.createSpawnPageBiomeTooltip(this.biomeFunction, this.weight)).isEmpty()) {
            tooltip.addAll(biomeTooltip);
        }
    }

    public BedrockFluidDepositDefinition getDefinition() {
        return this.definition;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getWeight() {
        return this.weight;
    }

    public int[] getYields() {
        return this.yields;
    }

    public int getDepletionAmount() {
        return this.depletionAmount;
    }

    public int getDepletionChance() {
        return this.depletionChance;
    }

    public int getDepletedYield() {
        return this.depletedYield;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }
}

