/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.basic;

import gregtech.api.gui.GuiTextures;
import gregtech.api.util.GTJEIUtility;
import gregtech.api.util.GTStringUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.integration.jei.basic.BasicRecipeCategory;
import gregtech.integration.jei.basic.GTOreInfo;
import gregtech.integration.jei.utils.render.ItemStackTextRenderer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;

public class GTOreCategory
extends BasicRecipeCategory<GTOreInfo, GTOreInfo> {
    protected final IDrawable slot;
    protected OreDepositDefinition definition;
    protected String veinName;
    protected int minHeight;
    protected int maxHeight;
    protected int outputCount;
    protected int weight;
    protected final Map<Integer, String> namedDimensions = WorldGenRegistry.getNamedDimensions();
    private Supplier<List<Integer>> dimension;
    private final int NUM_OF_SLOTS = 5;
    private final int SLOT_WIDTH = 18;
    private final int SLOT_HEIGHT = 18;

    public GTOreCategory(IGuiHelper guiHelper) {
        super("ore_spawn_location", "ore.spawnlocation.name", (IDrawable)guiHelper.createBlankDrawable(176, 166), guiHelper);
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public void setRecipe(IRecipeLayout recipeLayout, GTOreInfo recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        int baseYPos = 19;
        itemStackGroup.init(0, true, 22, baseYPos);
        itemStackGroup.init(1, true, 22, 73);
        for (int i = 0; i < recipeWrapper.getOutputCount(); ++i) {
            int yPos = baseYPos + i / 5 * 18;
            int xPos = 70 + i % 5 * 18;
            itemStackGroup.init(i + 2, false, (IIngredientRenderer)new ItemStackTextRenderer(recipeWrapper.getOreWeight(i) * 100, -1), xPos + 1, yPos + 1, 16, 16, 0, 0);
        }
        itemStackGroup.addTooltipCallback(recipeWrapper::addTooltip);
        itemStackGroup.set(ingredients);
        this.veinName = recipeWrapper.getVeinName();
        this.minHeight = recipeWrapper.getMinHeight();
        this.maxHeight = recipeWrapper.getMaxHeight();
        this.outputCount = recipeWrapper.getOutputCount();
        this.weight = recipeWrapper.getWeight();
        this.definition = recipeWrapper.getDefinition();
        this.dimension = GTUtility.getAllRegisteredDimensions(this.definition.getDimensionFilter());
        GTJEIUtility.cleanupDimensionList(this.dimension);
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull GTOreInfo recipe) {
        return recipe;
    }

    @Override
    public void drawExtras(@Nonnull Minecraft minecraft) {
        int baseXPos = 70;
        int baseYPos = 19;
        int dimDisplayPos = 70;
        this.slot.draw(minecraft, 22, baseYPos);
        this.slot.draw(minecraft, 22, 73);
        int yPos = 0;
        for (int i = 0; i < this.outputCount; ++i) {
            yPos = baseYPos + i / 5 * 18;
            int xPos = baseXPos + i % 5 * 18;
            this.slot.draw(minecraft, xPos, yPos);
        }
        baseYPos = yPos + 18;
        GTStringUtils.drawCenteredStringWithCutoff(this.veinName, minecraft.field_71466_p, 176);
        if (baseYPos >= 90) {
            minecraft.field_71466_p.func_78276_b("Spawn Range: " + this.minHeight + "-" + this.maxHeight, baseXPos, baseYPos + 1, 0x111111);
        } else {
            minecraft.field_71466_p.func_78276_b("Spawn Range: " + this.minHeight + "-" + this.maxHeight, baseXPos, 73, 0x111111);
            baseYPos = 73;
        }
        minecraft.field_71466_p.func_78276_b("Vein Weight: " + this.weight, baseXPos, baseYPos + this.FONT_HEIGHT, 0x111111);
        minecraft.field_71466_p.func_78276_b("Dimensions: ", baseXPos, baseYPos + 2 * this.FONT_HEIGHT, 0x111111);
        GTJEIUtility.drawMultiLineCommaSeparatedDimensionList(this.namedDimensions, this.dimension.get(), minecraft.field_71466_p, baseXPos, baseYPos + 3 * this.FONT_HEIGHT, dimDisplayPos);
        minecraft.field_71466_p.func_78279_b("SurfaceMaterial", 15, 92, minecraft.field_71466_p.func_78256_a("Surface"), 0x111111);
    }
}

