/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverEnderFluidLink;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverFluidVoidingAdvanced;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.CoverItemVoidingAdvanced;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.IFilterMode;
import gregtech.common.covers.IIOMode;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.VoidingMode;
import gregtech.common.covers.filter.FluidFilter;
import gregtech.common.covers.filter.FluidFilterContainer;
import gregtech.common.covers.filter.ItemFilter;
import gregtech.common.covers.filter.ItemFilterContainer;
import gregtech.common.covers.filter.OreDictionaryItemFilter;
import gregtech.common.covers.filter.SmartItemFilter;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;

public class CoverProvider
extends CapabilityInfoProvider<ICoverable> {
    @Override
    @Nonnull
    protected Capability<ICoverable> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_COVERABLE;
    }

    public String getID() {
        return "gregtech:coverable_provider";
    }

    @Override
    protected void addProbeInfo(@Nonnull ICoverable capability, @Nonnull IProbeInfo probeInfo, @Nonnull EntityPlayer player, @Nonnull TileEntity tileEntity, @Nonnull IProbeHitData data) {
        CoverBehavior coverBehavior = capability.getCoverAtSide(data.getSideHit());
        if (coverBehavior instanceof CoverConveyor) {
            CoverProvider.conveyorInfo(probeInfo, (CoverConveyor)coverBehavior);
        } else if (coverBehavior instanceof CoverPump) {
            CoverProvider.pumpInfo(probeInfo, (CoverPump)coverBehavior);
        } else if (coverBehavior instanceof CoverItemFilter) {
            CoverProvider.itemFilterInfo(probeInfo, (CoverItemFilter)coverBehavior);
        } else if (coverBehavior instanceof CoverFluidFilter) {
            CoverProvider.fluidFilterInfo(probeInfo, (CoverFluidFilter)coverBehavior);
        } else if (coverBehavior instanceof CoverEnderFluidLink) {
            CoverProvider.enderFluidLinkInfo(probeInfo, (CoverEnderFluidLink)coverBehavior);
        }
    }

    private static void conveyorInfo(@Nonnull IProbeInfo probeInfo, @Nonnull CoverConveyor conveyor) {
        String rateUnit = " {*cover.conveyor.transfer_rate*}";
        if (conveyor instanceof CoverItemVoiding) {
            CoverProvider.itemVoidingInfo(probeInfo, (CoverItemVoiding)conveyor);
        } else if (!(conveyor instanceof CoverRoboticArm) || ((CoverRoboticArm)conveyor).getTransferMode() == TransferMode.TRANSFER_ANY) {
            CoverProvider.transferRateText(probeInfo, conveyor.getConveyorMode(), rateUnit, conveyor.getTransferRate());
        }
        ItemFilterContainer filter = conveyor.getItemFilterContainer();
        if (conveyor instanceof CoverRoboticArm) {
            CoverRoboticArm roboticArm = (CoverRoboticArm)conveyor;
            CoverProvider.transferModeText(probeInfo, roboticArm.getTransferMode(), rateUnit, filter.getTransferStackSize(), filter.getFilterWrapper().getItemFilter() != null);
        }
        CoverProvider.itemFilterText(probeInfo, filter.getFilterWrapper().getItemFilter());
    }

    private static void itemVoidingInfo(@Nonnull IProbeInfo probeInfo, @Nonnull CoverItemVoiding voiding) {
        String unit = " {*gregtech.top.unit.items*}";
        ItemFilterContainer container = voiding.getItemFilterContainer();
        if (voiding instanceof CoverItemVoidingAdvanced) {
            CoverItemVoidingAdvanced advanced = (CoverItemVoidingAdvanced)voiding;
            VoidingMode mode = advanced.getVoidingMode();
            CoverProvider.voidingText(probeInfo, mode, unit, container.getTransferStackSize(), container.getFilterWrapper().getItemFilter() != null);
        }
    }

    private static void pumpInfo(@Nonnull IProbeInfo probeInfo, @Nonnull CoverPump pump) {
        String rateUnit = "{*" + pump.getBucketMode().func_176610_l() + "*}";
        if (pump instanceof CoverFluidVoiding) {
            CoverProvider.fluidVoidingInfo(probeInfo, (CoverFluidVoiding)pump);
        } else if (!(pump instanceof CoverFluidRegulator) || ((CoverFluidRegulator)pump).getTransferMode() == TransferMode.TRANSFER_ANY) {
            CoverProvider.transferRateText(probeInfo, pump.getPumpMode(), " " + rateUnit, pump.getBucketMode() == CoverPump.BucketMode.BUCKET ? pump.getTransferRate() / 1000 : pump.getTransferRate());
        }
        FluidFilterContainer filter = pump.getFluidFilterContainer();
        if (pump instanceof CoverFluidRegulator) {
            CoverFluidRegulator regulator = (CoverFluidRegulator)pump;
            CoverProvider.transferModeText(probeInfo, regulator.getTransferMode(), rateUnit, regulator.getTransferAmount(), filter.getFilterWrapper().getFluidFilter() != null);
        }
        CoverProvider.fluidFilterText(probeInfo, filter.getFilterWrapper().getFluidFilter());
    }

    private static void fluidVoidingInfo(@Nonnull IProbeInfo probeInfo, @Nonnull CoverFluidVoiding voiding) {
        String unit;
        String string = unit = voiding.getBucketMode() == CoverPump.BucketMode.BUCKET ? " {*gregtech.top.unit.fluid_buckets*}" : " {*gregtech.top.unit.fluid_milibuckets*}";
        if (voiding instanceof CoverFluidVoidingAdvanced) {
            CoverFluidVoidingAdvanced advanced = (CoverFluidVoidingAdvanced)voiding;
            VoidingMode mode = advanced.getVoidingMode();
            CoverProvider.voidingText(probeInfo, mode, unit, voiding.getBucketMode() == CoverPump.BucketMode.BUCKET ? advanced.getTransferAmount() / 1000 : advanced.getTransferAmount(), voiding.getFluidFilterContainer().getFilterWrapper().getFluidFilter() != null);
        }
    }

    private static void itemFilterInfo(@Nonnull IProbeInfo probeInfo, @Nonnull CoverItemFilter itemFilter) {
        CoverProvider.filterModeText(probeInfo, itemFilter.getFilterMode());
        CoverProvider.itemFilterText(probeInfo, itemFilter.getItemFilter().getItemFilter());
    }

    private static void fluidFilterInfo(@Nonnull IProbeInfo probeInfo, @Nonnull CoverFluidFilter fluidFilter) {
        CoverProvider.filterModeText(probeInfo, fluidFilter.getFilterMode());
        CoverProvider.fluidFilterText(probeInfo, fluidFilter.getFluidFilter().getFluidFilter());
    }

    private static void enderFluidLinkInfo(@Nonnull IProbeInfo probeInfo, @Nonnull CoverEnderFluidLink enderFluidLink) {
        CoverProvider.transferRateText(probeInfo, enderFluidLink.getPumpMode(), " {*cover.bucket.mode.milli_bucket*}", enderFluidLink.isIOEnabled() ? 8000 : 0);
        CoverProvider.fluidFilterText(probeInfo, enderFluidLink.getFluidFilterContainer().getFilterWrapper().getFluidFilter());
        if (!enderFluidLink.getColorStr().isEmpty()) {
            probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.link_cover.color*} " + enderFluidLink.getColorStr());
        }
    }

    private static void transferRateText(@Nonnull IProbeInfo probeInfo, @Nonnull IIOMode mode, @Nonnull String rateUnit, int rate) {
        String modeText = mode.isImport() ? "{*gregtech.top.mode.import*} " : "{*gregtech.top.mode.export*} ";
        probeInfo.text(TextStyleClass.OK + modeText + TextStyleClass.LABEL + GTUtility.formatNumbers(rate) + rateUnit);
    }

    private static void transferModeText(@Nonnull IProbeInfo probeInfo, @Nonnull TransferMode mode, @Nonnull String rateUnit, int rate, boolean hasFilter) {
        String text = TextStyleClass.OK + "{*" + mode.func_176610_l() + "*}";
        if (!hasFilter && mode != TransferMode.TRANSFER_ANY) {
            text = text + TextStyleClass.LABEL + " " + rate + rateUnit;
        }
        probeInfo.text(text);
    }

    private static void voidingText(@Nonnull IProbeInfo probeInfo, @Nonnull VoidingMode mode, @Nonnull String unit, int amount, boolean hasFilter) {
        String text = TextFormatting.RED + "{*" + mode.func_176610_l() + "*}";
        if (mode != VoidingMode.VOID_ANY && !hasFilter) {
            text = text + " " + amount + unit;
        }
        probeInfo.text(text);
    }

    private static void filterModeText(@Nonnull IProbeInfo probeInfo, @Nonnull IFilterMode mode) {
        probeInfo.text(TextStyleClass.WARNING + "{*" + mode.getName() + "*}");
    }

    private static void itemFilterText(@Nonnull IProbeInfo probeInfo, @Nullable ItemFilter filter) {
        String label = TextStyleClass.INFO + "{*gregtech.top.filter.label*} ";
        if (filter instanceof OreDictionaryItemFilter) {
            String expression = ((OreDictionaryItemFilter)filter).getExpression();
            if (!expression.isEmpty()) {
                probeInfo.text(label + expression);
            }
        } else if (filter instanceof SmartItemFilter) {
            probeInfo.text(label + "{*" + ((SmartItemFilter)filter).getFilteringMode().func_176610_l() + "*}");
        }
    }

    private static void fluidFilterText(@Nonnull IProbeInfo probeInfo, @Nullable FluidFilter filter) {
    }
}

