/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTLog;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryLoader {
    public static final String OREDICT_FUEL_COKE = "fuelCoke";
    public static final String OREDICT_BLOCK_FUEL_COKE = "blockFuelCoke";

    public static void init() {
        GTLog.logger.info("Registering OreDict entries.");
        OreDictionary.registerOre((String)OREDICT_FUEL_COKE, (ItemStack)OreDictUnifier.get(OrePrefix.gem, Materials.Coke));
        OreDictionary.registerOre((String)OREDICT_BLOCK_FUEL_COKE, (ItemStack)OreDictUnifier.get(OrePrefix.block, Materials.Coke));
        OreDictionary.registerOre((String)"crystalCertusQuartz", (ItemStack)OreDictUnifier.get(OrePrefix.gem, Materials.CertusQuartz));
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150435_aG), OrePrefix.block, Materials.Clay);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150336_V), OrePrefix.block, Materials.Brick);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151119_aD), OrePrefix.ingot, Materials.Clay);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151145_ak), OrePrefix.gem, Materials.Flint);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE), new ItemMaterialInfo(new MaterialStack(Materials.Clay, 14515200L)));
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE), new ItemMaterialInfo(new MaterialStack(Materials.Clay, 14515200L)));
        for (Material material : new Material[]{Materials.Wood, Materials.TreatedWood}) {
            for (ItemStack woodPlateStack : OreDictUnifier.getAll(new UnificationEntry(OrePrefix.plate, material))) {
                OreDictUnifier.registerOre(woodPlateStack, OrePrefix.plank, material);
            }
        }
        for (Material material : new Material[]{Materials.Lapis, Materials.Lazurite, Materials.Sodalite}) {
            OreDictUnifier.registerOre(OreDictUnifier.get(OrePrefix.gem, material), OrePrefix.dye, (Material)MarkerMaterials.Color.Blue);
            OreDictUnifier.registerOre(OreDictUnifier.get(OrePrefix.dust, material), OrePrefix.dye, (Material)MarkerMaterials.Color.Blue);
        }
        OreDictUnifier.registerOre(OreDictUnifier.get(OrePrefix.dust, Materials.MetalMixture), OrePrefix.dye, (Material)MarkerMaterials.Color.Brown);
        OreDictUnifier.registerOre(OreDictUnifier.get(OrePrefix.lens, Materials.Glass), OrePrefix.craftingLens, (Material)MarkerMaterials.Color.White);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150365_q), OrePrefix.ore, Materials.Coal);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150366_p), OrePrefix.ore, Materials.Iron);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150369_x), OrePrefix.ore, Materials.Lapis);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150450_ax), OrePrefix.ore, Materials.Redstone);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150352_o), OrePrefix.ore, Materials.Gold);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150482_ag), OrePrefix.ore, Materials.Diamond);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150412_bA), OrePrefix.ore, Materials.Emerald);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150449_bY), OrePrefix.ore, Materials.NetherQuartz);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151100_aR, 1, 4), OrePrefix.gem, Materials.Lapis);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151061_bv), OrePrefix.gem, Materials.EnderEye);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151079_bi), OrePrefix.gem, Materials.EnderPearl);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151045_i), OrePrefix.gem, Materials.Diamond);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151166_bC), OrePrefix.gem, Materials.Emerald);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151044_h), OrePrefix.gem, Materials.Coal);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151044_h, 1, 1), OrePrefix.gem, Materials.Charcoal);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151128_bU), OrePrefix.gem, Materials.NetherQuartz);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151156_bN), OrePrefix.gem, Materials.NetherStar);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151074_bl), OrePrefix.nugget, Materials.Gold);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151043_k), OrePrefix.ingot, Materials.Gold);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151042_j), OrePrefix.ingot, Materials.Iron);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151121_aF), OrePrefix.plate, Materials.Paper);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151102_aT), OrePrefix.dust, Materials.Sugar);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151055_y), OrePrefix.stick, Materials.Wood);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151137_ax), OrePrefix.dust, Materials.Redstone);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151016_H), OrePrefix.dust, Materials.Gunpowder);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151114_aO), OrePrefix.dust, Materials.Glowstone);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150426_aN), OrePrefix.block, Materials.Glowstone);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151100_aR, 1, 15), OrePrefix.dust, Materials.Bone);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151103_aS), OrePrefix.stick, Materials.Bone);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151065_br), OrePrefix.dust, Materials.Blaze);
        OreDictUnifier.registerOre(new ItemStack(Items.field_151072_bj), OrePrefix.stick, Materials.Blaze);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150339_S), OrePrefix.block, Materials.Iron);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150340_R), OrePrefix.block, Materials.Gold);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150484_ah), OrePrefix.block, Materials.Diamond);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150475_bE), OrePrefix.block, Materials.Emerald);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150368_y), OrePrefix.block, Materials.Lapis);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150402_ci), OrePrefix.block, Materials.Coal);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150451_bX), OrePrefix.block, Materials.Redstone);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150371_ca), OrePrefix.block, Materials.NetherQuartz);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_189880_di), OrePrefix.block, Materials.Bone);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150432_aD), OrePrefix.block, Materials.Ice);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150343_Z), OrePrefix.block, Materials.Obsidian);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150359_w), OrePrefix.block, Materials.Glass);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150348_b, 1, 1), OrePrefix.stone, Materials.Granite);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150348_b, 1, 2), OrePrefix.stone, Materials.Granite);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150348_b, 1, 5), OrePrefix.stone, Materials.Andesite);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150348_b, 1, 6), OrePrefix.stone, Materials.Andesite);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150348_b, 1, 3), OrePrefix.stone, Materials.Diorite);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150348_b, 1, 4), OrePrefix.stone, Materials.Diorite);
        for (StoneVariantBlock.StoneType stoneType : StoneVariantBlock.StoneType.values()) {
            ItemStack item = MetaBlocks.STONE_BLOCKS.get((Object)StoneVariantBlock.StoneVariant.SMOOTH).getItemVariant(stoneType);
            OreDictUnifier.registerOre(item, stoneType.getOrePrefix(), stoneType.getMaterial());
        }
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150467_bQ), "craftingAnvil");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150343_Z, 1, Short.MAX_VALUE), OrePrefix.stone, Materials.Obsidian);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150341_Y, 1, Short.MAX_VALUE), "stoneMossy");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150341_Y, 1, Short.MAX_VALUE), "stoneCobble");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150347_e, 1, Short.MAX_VALUE), "stoneCobble");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150348_b, 1, Short.MAX_VALUE), "stoneSmooth");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE), "stoneBricks");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150417_aV, 1, 1), "stoneMossy");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150417_aV, 1, 2), "stoneCracked");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150417_aV, 1, 3), "stoneChiseled");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150424_aL, 1, Short.MAX_VALUE), OrePrefix.stone, Materials.Netherrack);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150377_bs, 1, Short.MAX_VALUE), OrePrefix.stone, Materials.Endstone);
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150429_aA, 1, Short.MAX_VALUE), "craftingRedstoneTorch");
        OreDictUnifier.registerOre(new ItemStack((Block)Blocks.field_150331_J, 1, Short.MAX_VALUE), "craftingPiston");
        OreDictUnifier.registerOre(new ItemStack((Block)Blocks.field_150320_F, 1, Short.MAX_VALUE), "craftingPiston");
        OreDictUnifier.registerOre(new ItemStack((Block)Blocks.field_150486_ae, 1, Short.MAX_VALUE), "chestWood");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150447_bR, 1, Short.MAX_VALUE), "chestWood");
        OreDictUnifier.registerOre(new ItemStack(Blocks.field_150460_al, 1, Short.MAX_VALUE), "craftingFurnace");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151008_G, 1, Short.MAX_VALUE), "craftingFeather");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151015_O, 1, Short.MAX_VALUE), "itemWheat");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151121_aF, 1, Short.MAX_VALUE), "paperEmpty");
        OreDictUnifier.registerOre(new ItemStack((Item)Items.field_151148_bJ, 1, Short.MAX_VALUE), "paperMap");
        OreDictUnifier.registerOre(new ItemStack((Item)Items.field_151098_aY, 1, Short.MAX_VALUE), "paperMap");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151122_aG, 1, Short.MAX_VALUE), "bookEmpty");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151099_bA, 1, Short.MAX_VALUE), "bookWritable");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151164_bB, 1, Short.MAX_VALUE), "bookWritten");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151134_bR, 1, Short.MAX_VALUE), "bookEnchanted");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151122_aG, 1, Short.MAX_VALUE), "craftingBook");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151099_bA, 1, Short.MAX_VALUE), "craftingBook");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151164_bB, 1, Short.MAX_VALUE), "craftingBook");
        OreDictUnifier.registerOre(new ItemStack(Items.field_151134_bR, 1, Short.MAX_VALUE), "craftingBook");
    }
}

