/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.BlastRecipeBuilder;
import gregtech.api.recipes.builders.ImplosionRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtech.loaders.recipe.CraftingComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MaterialRecipeHandler {
    private static final List<OrePrefix> GEM_ORDER = ConfigHolder.recipes.generateLowQualityGems ? Arrays.asList(OrePrefix.gemChipped, OrePrefix.gemFlawed, OrePrefix.gem, OrePrefix.gemFlawless, OrePrefix.gemExquisite) : Arrays.asList(OrePrefix.gem, OrePrefix.gemFlawless, OrePrefix.gemExquisite);

    public static void register() {
        OrePrefix.ingot.addProcessingHandler(PropertyKey.INGOT, MaterialRecipeHandler::processIngot);
        OrePrefix.nugget.addProcessingHandler(PropertyKey.DUST, MaterialRecipeHandler::processNugget);
        OrePrefix.block.addProcessingHandler(PropertyKey.DUST, MaterialRecipeHandler::processBlock);
        OrePrefix.frameGt.addProcessingHandler(PropertyKey.DUST, MaterialRecipeHandler::processFrame);
        OrePrefix.dust.addProcessingHandler(PropertyKey.DUST, MaterialRecipeHandler::processDust);
        OrePrefix.dustSmall.addProcessingHandler(PropertyKey.DUST, MaterialRecipeHandler::processSmallDust);
        OrePrefix.dustTiny.addProcessingHandler(PropertyKey.DUST, MaterialRecipeHandler::processTinyDust);
        for (OrePrefix orePrefix : GEM_ORDER) {
            orePrefix.addProcessingHandler(PropertyKey.GEM, MaterialRecipeHandler::processGemConversion);
        }
    }

    public static void processDust(OrePrefix dustPrefix, Material mat, DustProperty property) {
        OreProperty oreProperty;
        ItemStack dustStack = OreDictUnifier.get(dustPrefix, mat);
        OreProperty oreProperty2 = oreProperty = mat.hasProperty(PropertyKey.ORE) ? mat.getProperty(PropertyKey.ORE) : null;
        if (mat.hasProperty(PropertyKey.GEM)) {
            Material smeltingResult;
            ItemStack gemStack = OreDictUnifier.get(OrePrefix.gem, mat);
            ItemStack smallDarkAshStack = OreDictUnifier.get(OrePrefix.dustSmall, Materials.DarkAsh);
            if (mat.hasFlag(MaterialFlags.CRYSTALLIZABLE)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(dustStack)).fluidInputs(Materials.Water.getFluid(250))).chancedOutput(gemStack, 7000, 1000)).duration(1200)).EUt(24)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.AUTOCLAVE_RECIPES.recipeBuilder().inputs(dustStack)).fluidInputs(Materials.DistilledWater.getFluid(50))).outputs(gemStack)).duration(600)).EUt(24)).buildAndRegister();
            }
            if (!mat.hasFlag(MaterialFlags.EXPLOSIVE) && !mat.hasFlag(MaterialFlags.FLAMMABLE)) {
                ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder().inputs(GTUtility.copyAmount(4, dustStack))).outputs(GTUtility.copyAmount(3, gemStack), smallDarkAshStack)).explosivesAmount(2).buildAndRegister();
                ((ImplosionRecipeBuilder)((ImplosionRecipeBuilder)RecipeMaps.IMPLOSION_RECIPES.recipeBuilder().inputs(GTUtility.copyAmount(4, dustStack))).outputs(GTUtility.copyAmount(3, gemStack), smallDarkAshStack)).explosivesType(MetaItems.DYNAMITE.getStackForm()).buildAndRegister();
            }
            if (oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()) != null) {
                ModHandler.addSmeltingRecipe(OreDictUnifier.get(dustPrefix, mat), OreDictUnifier.get(OrePrefix.ingot, smeltingResult));
            }
        } else if (mat.hasProperty(PropertyKey.INGOT)) {
            if (!mat.hasAnyOfFlags(MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING)) {
                int blastTemp;
                Material smeltingResult;
                boolean hasHotIngot = OrePrefix.ingotHot.doGenerateItem(mat);
                ItemStack ingotStack = OreDictUnifier.get(hasHotIngot ? OrePrefix.ingotHot : OrePrefix.ingot, mat);
                if (ingotStack.func_190926_b() && oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()) != null) {
                    ingotStack = OreDictUnifier.get(OrePrefix.ingot, smeltingResult);
                }
                if ((blastTemp = mat.getBlastTemperature()) <= 0) {
                    if (!mat.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                        ModHandler.addSmeltingRecipe(OreDictUnifier.get(dustPrefix, mat), ingotStack);
                    }
                } else {
                    IngotProperty ingotProperty = mat.getProperty(PropertyKey.INGOT);
                    BlastProperty blastProperty = mat.getProperty(PropertyKey.BLAST);
                    MaterialRecipeHandler.processEBFRecipe(mat, blastProperty, ingotStack);
                    if (ingotProperty.getMagneticMaterial() != null) {
                        MaterialRecipeHandler.processEBFRecipe(ingotProperty.getMagneticMaterial(), blastProperty, ingotStack);
                    }
                }
            }
        } else {
            ItemStack ingotStack;
            Material smeltingResult;
            if (mat.hasFlag(MaterialFlags.GENERATE_PLATE) && !mat.hasFlag(MaterialFlags.EXCLUDE_PLATE_COMPRESSOR_RECIPE)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().inputs(dustStack)).outputs(OreDictUnifier.get(OrePrefix.plate, mat))).buildAndRegister();
            }
            if (oreProperty != null && (smeltingResult = oreProperty.getDirectSmeltResult()) != null && !(ingotStack = OreDictUnifier.get(OrePrefix.ingot, smeltingResult)).func_190926_b()) {
                ModHandler.addSmeltingRecipe(OreDictUnifier.get(dustPrefix, mat), ingotStack);
            }
        }
    }

    private static void processEBFRecipe(Material material, BlastProperty property, ItemStack output) {
        int EUt;
        int blastTemp = property.getBlastTemperature();
        BlastProperty.GasTier gasTier = property.getGasTier();
        int duration = property.getDurationOverride();
        if (duration <= 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)blastTemp / 50L));
        }
        if ((EUt = property.getEUtOverride()) <= 0) {
            EUt = GTValues.VA[2];
        }
        BlastRecipeBuilder blastBuilder = (BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)RecipeMaps.BLAST_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).outputs(output)).blastFurnaceTemp(blastTemp).EUt(EUt);
        if (gasTier != null) {
            FluidStack gas = CraftingComponent.EBF_GASES.get((Object)gasTier).copy();
            ((BlastRecipeBuilder)((BlastRecipeBuilder)blastBuilder.copy().circuitMeta(1)).duration(duration)).buildAndRegister();
            ((BlastRecipeBuilder)((BlastRecipeBuilder)((BlastRecipeBuilder)blastBuilder.copy().circuitMeta(2)).fluidInputs(gas)).duration((int)((double)duration * 0.67))).buildAndRegister();
        } else {
            blastBuilder.duration(duration);
            if (material == Materials.Silicon) {
                blastBuilder.circuitMeta(1);
            }
            blastBuilder.buildAndRegister();
        }
        if (OrePrefix.ingotHot.doGenerateItem(material)) {
            if (blastTemp < 5000) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder().input(OrePrefix.ingotHot, material)).output(OrePrefix.ingot, material)).duration((int)material.getMass() * 3)).buildAndRegister();
            } else {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.VACUUM_RECIPES.recipeBuilder().input(OrePrefix.ingotHot, material)).fluidInputs(Materials.LiquidHelium.getFluid(500))).output(OrePrefix.ingot, material)).fluidOutputs(Materials.Helium.getFluid(250))).duration((int)material.getMass() * 3)).buildAndRegister();
            }
        }
    }

    public static void processSmallDust(OrePrefix orePrefix, Material material, DustProperty property) {
        ItemStack smallDustStack = OreDictUnifier.get(orePrefix, material);
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
        ModHandler.addShapedRecipe(String.format("small_dust_disassembling_%s", material), GTUtility.copyAmount(4, smallDustStack), " X", "  ", Character.valueOf('X'), new UnificationEntry(OrePrefix.dust, material));
        ModHandler.addShapedRecipe(String.format("small_dust_assembling_%s", material), dustStack, "XX", "XX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(orePrefix, material, 4)).circuitMeta(1)).outputs(dustStack)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).circuitMeta(2)).outputs(GTUtility.copyAmount(4, smallDustStack))).buildAndRegister();
    }

    public static void processTinyDust(OrePrefix orePrefix, Material material, DustProperty property) {
        ItemStack tinyDustStack = OreDictUnifier.get(orePrefix, material);
        ItemStack dustStack = OreDictUnifier.get(OrePrefix.dust, material);
        ModHandler.addShapedRecipe(String.format("tiny_dust_disassembling_%s", material), GTUtility.copyAmount(9, tinyDustStack), "X ", "  ", Character.valueOf('X'), new UnificationEntry(OrePrefix.dust, material));
        ModHandler.addShapedRecipe(String.format("tiny_dust_assembling_%s", material), dustStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(orePrefix, material, 9)).circuitMeta(1)).outputs(dustStack)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PACKER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).circuitMeta(1)).outputs(GTUtility.copyAmount(9, tinyDustStack))).buildAndRegister();
    }

    public static void processIngot(OrePrefix ingotPrefix, Material material, IngotProperty property) {
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            ModHandler.addShapedRecipe(String.format("mortar_grind_%s", material), OreDictUnifier.get(OrePrefix.dust, material), "X", "m", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material));
        }
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            ModHandler.addShapedRecipe(String.format("stick_%s", material), OreDictUnifier.get(OrePrefix.stick, material, 1), "f ", " X", Character.valueOf('X'), new UnificationEntry(ingotPrefix, material));
            if (!material.hasFlag(MaterialFlags.NO_WORKING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(ingotPrefix, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD)).outputs(OreDictUnifier.get(OrePrefix.stick, material, 2))).duration((int)material.getMass() * 2)).EUt(6 * MaterialRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
            }
        }
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_INGOT)).fluidInputs(material.getFluid(144))).outputs(OreDictUnifier.get(ingotPrefix, material))).duration(20)).EUt(GTValues.VA[0])).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_INGOT)).outputs(OreDictUnifier.get(OrePrefix.ingot, material))).duration(10)).EUt(4 * MaterialRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).duration((int)material.getMass())).input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_MOLD_NUGGET.getStackForm())).output(OrePrefix.nugget, material, 9)).buildAndRegister();
        if (!OreDictUnifier.get(OrePrefix.block, material).func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).duration((int)material.getMass() * 9)).input(OrePrefix.block, material)).notConsumable(MetaItems.SHAPE_MOLD_INGOT.getStackForm())).output(OrePrefix.ingot, material, 9)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().EUt(2)).duration(300)).input(OrePrefix.ingot, material, (int)(OrePrefix.block.getMaterialAmount(material) / 3628800L))).output(OrePrefix.block, material)).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !material.hasFlag(MaterialFlags.NO_WORKING)) {
            ItemStack plateStack;
            if (!material.hasFlag(MaterialFlags.NO_SMASHING) && !(plateStack = OreDictUnifier.get(OrePrefix.plate, material)).func_190926_b()) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().circuitMeta(1)).input(ingotPrefix, material)).outputs(plateStack)).EUt(24)).duration((int)material.getMass())).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(ingotPrefix, material, 3)).outputs(GTUtility.copyAmount(2, plateStack))).EUt(16)).duration((int)material.getMass())).buildAndRegister();
                ModHandler.addShapedRecipe(String.format("plate_%s", material), plateStack, "h", "I", "I", Character.valueOf('I'), new UnificationEntry(ingotPrefix, material));
            }
            int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
            if (!OreDictUnifier.get(OrePrefix.plate, material).func_190926_b()) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(ingotPrefix, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_PLATE)).outputs(OreDictUnifier.get(OrePrefix.plate, material))).duration((int)material.getMass())).EUt(8 * voltageMultiplier)).buildAndRegister();
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_PLATE)).outputs(OreDictUnifier.get(OrePrefix.plate, material))).duration((int)material.getMass())).EUt(8 * voltageMultiplier)).buildAndRegister();
                }
            }
        }
    }

    public static void processGemConversion(OrePrefix gemPrefix, Material material, GemProperty property) {
        OrePrefix prevPrefix;
        ItemStack prevStack;
        long materialAmount = gemPrefix.getMaterialAmount(material);
        ItemStack crushedStack = OreDictUnifier.getDust(material, materialAmount);
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            ModHandler.addShapedRecipe(String.format("gem_to_dust_%s_%s", material, gemPrefix), crushedStack, "X", "m", Character.valueOf('X'), new UnificationEntry(gemPrefix, material));
        }
        ItemStack itemStack = prevStack = (prevPrefix = (OrePrefix)GTUtility.getItem(GEM_ORDER, GEM_ORDER.indexOf(gemPrefix) - 1, null)) == null ? ItemStack.field_190927_a : OreDictUnifier.get(prevPrefix, material, 2);
        if (!prevStack.func_190926_b()) {
            ModHandler.addShapelessRecipe(String.format("gem_to_gem_%s_%s", prevPrefix, material), prevStack, "h", new UnificationEntry(gemPrefix, material));
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(gemPrefix, material)).outputs(prevStack)).duration(20)).EUt(16)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LASER_ENGRAVER_RECIPES.recipeBuilder().inputs(prevStack)).notConsumable(OrePrefix.craftingLens, MarkerMaterials.Color.White)).output(gemPrefix, material)).duration(300)).EUt(240)).buildAndRegister();
        }
    }

    public static void processNugget(OrePrefix orePrefix, Material material, DustProperty property) {
        ItemStack nuggetStack = OreDictUnifier.get(orePrefix, material);
        if (material.hasProperty(PropertyKey.INGOT)) {
            ItemStack ingotStack = OreDictUnifier.get(OrePrefix.ingot, material);
            if (!ConfigHolder.recipes.disableManualCompression) {
                ModHandler.addShapelessRecipe(String.format("nugget_disassembling_%s", material), GTUtility.copyAmount(9, nuggetStack), new UnificationEntry(OrePrefix.ingot, material));
                ModHandler.addShapedRecipe(String.format("nugget_assembling_%s", material), ingotStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.nugget, material, 9)).output(OrePrefix.ingot, material)).EUt(2)).duration(300)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).duration((int)material.getMass())).input(OrePrefix.nugget, material, 9)).notConsumable(MetaItems.SHAPE_MOLD_INGOT.getStackForm())).output(OrePrefix.ingot, material)).buildAndRegister();
            if (material.hasFluid()) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_NUGGET)).fluidInputs(material.getFluid(144))).outputs(OreDictUnifier.get(orePrefix, material, 9))).duration((int)material.getMass())).EUt(GTValues.VA[0])).buildAndRegister();
            }
        } else if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack gemStack = OreDictUnifier.get(OrePrefix.gem, material);
            if (!ConfigHolder.recipes.disableManualCompression) {
                ModHandler.addShapelessRecipe(String.format("nugget_disassembling_%s", material), GTUtility.copyAmount(9, nuggetStack), new UnificationEntry(OrePrefix.gem, material));
                ModHandler.addShapedRecipe(String.format("nugget_assembling_%s", material), gemStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new UnificationEntry(orePrefix, material));
            }
        }
    }

    public static void processFrame(OrePrefix framePrefix, Material material, DustProperty property) {
        if (material.hasFlag(MaterialFlags.GENERATE_FRAME)) {
            boolean isWoodenFrame = ModHandler.isMaterialWood(material);
            ModHandler.addShapedRecipe(String.format("frame_%s", material), OreDictUnifier.get(framePrefix, material, 2), "SSS", isWoodenFrame ? "SsS" : "SwS", "SSS", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material));
            ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.stick, material, 4)).circuitMeta(4)).outputs(OreDictUnifier.get(framePrefix, material, 1))).EUt(GTValues.VA[0])).duration(64)).buildAndRegister();
        }
    }

    public static void processBlock(OrePrefix blockPrefix, Material material, DustProperty property) {
        ItemStack plateStack;
        ItemStack blockStack = OreDictUnifier.get(blockPrefix, material);
        long materialAmount = blockPrefix.getMaterialAmount(material);
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).fluidInputs(material.getFluid((int)(materialAmount * 144L / 3628800L)))).outputs(blockStack)).duration((int)material.getMass())).EUt(GTValues.VA[0])).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !(plateStack = OreDictUnifier.get(OrePrefix.plate, material)).func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(blockPrefix, material)).outputs(GTUtility.copyAmount((int)(materialAmount / 3628800L), plateStack))).duration((int)(material.getMass() * 8L))).EUt(GTValues.VA[1])).buildAndRegister();
        }
        UnificationEntry blockEntry = material.hasProperty(PropertyKey.GEM) ? new UnificationEntry(OrePrefix.gem, material) : (material.hasProperty(PropertyKey.INGOT) ? new UnificationEntry(OrePrefix.ingot, material) : new UnificationEntry(OrePrefix.dust, material));
        ArrayList<UnificationEntry> result = new ArrayList<UnificationEntry>();
        int index = 0;
        while ((long)index < materialAmount / 3628800L) {
            result.add(blockEntry);
            ++index;
        }
        if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES)) {
            if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES) && !ConfigHolder.recipes.disableManualCompression) {
                ModHandler.addShapelessRecipe(String.format("block_compress_%s", material), blockStack, result.toArray());
                ModHandler.addShapelessRecipe(String.format("block_decompress_%s", material), GTUtility.copyAmount((int)(materialAmount / 3628800L), OreDictUnifier.get(blockEntry)), new UnificationEntry(blockPrefix, material));
            }
            if (material.hasProperty(PropertyKey.INGOT)) {
                int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, (int)(materialAmount / 3628800L))).notConsumable(MetaItems.SHAPE_EXTRUDER_BLOCK)).outputs(blockStack)).duration(10)).EUt(8 * voltageMultiplier)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, (int)(materialAmount / 3628800L))).notConsumable(MetaItems.SHAPE_MOLD_BLOCK)).outputs(blockStack)).duration(5)).EUt(4 * voltageMultiplier)).buildAndRegister();
            } else if (material.hasProperty(PropertyKey.GEM)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.COMPRESSOR_RECIPES.recipeBuilder().input(OrePrefix.gem, material, (int)(OrePrefix.block.getMaterialAmount(material) / 3628800L))).output(OrePrefix.block, material)).duration(300)).EUt(2)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(OrePrefix.block, material)).output(OrePrefix.gem, material, (int)(OrePrefix.block.getMaterialAmount(material) / 3628800L))).duration(100)).EUt(24)).buildAndRegister();
            }
        }
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

