/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.DyeUtil;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.TurbineRotorBehavior;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class PartsRecipeHandler {
    private PartsRecipeHandler() {
    }

    public static void register() {
        OrePrefix.stick.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processStick);
        OrePrefix.stickLong.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processLongStick);
        OrePrefix.plate.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processPlate);
        OrePrefix.plateDouble.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processPlateDouble);
        OrePrefix.plateDense.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processPlateDense);
        OrePrefix.turbineBlade.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processTurbine);
        OrePrefix.rotor.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processRotor);
        OrePrefix.bolt.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processBolt);
        OrePrefix.screw.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processScrew);
        OrePrefix.wireFine.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processFineWire);
        OrePrefix.foil.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processFoil);
        OrePrefix.lens.addProcessingHandler(PropertyKey.GEM, PartsRecipeHandler::processLens);
        OrePrefix.gear.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processGear);
        OrePrefix.gearSmall.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processGear);
        OrePrefix.ring.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processRing);
        OrePrefix.springSmall.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processSpringSmall);
        OrePrefix.spring.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processSpring);
        OrePrefix.round.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processRound);
    }

    public static void processBolt(OrePrefix boltPrefix, Material material, DustProperty property) {
        ItemStack boltStack = OreDictUnifier.get(boltPrefix, material);
        ItemStack ingotStack = OreDictUnifier.get(OrePrefix.ingot, material);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(OrePrefix.screw, material)).outputs(boltStack)).duration(20)).EUt(24)).buildAndRegister();
        if (!boltStack.func_190926_b() && !ingotStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_BOLT)).outputs(GTUtility.copyAmount(8, boltStack))).duration(15)).EUt(GTValues.VA[2])).buildAndRegister();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_BOLT)).outputs(GTUtility.copyAmount(8, boltStack))).duration(15)).EUt(GTValues.VA[2])).buildAndRegister();
            }
        }
    }

    public static void processScrew(OrePrefix screwPrefix, Material material, DustProperty property) {
        ItemStack screwStack = OreDictUnifier.get(screwPrefix, material);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.bolt, material)).outputs(screwStack)).duration((int)Math.max(1L, material.getMass() / 8L))).EUt(4)).buildAndRegister();
        ModHandler.addShapedRecipe(String.format("screw_%s", material), screwStack, "fX", "X ", Character.valueOf('X'), new UnificationEntry(OrePrefix.bolt, material));
    }

    public static void processFoil(OrePrefix foilPrefix, Material material, IngotProperty property) {
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ModHandler.addShapedRecipe(String.format("foil_%s", material), OreDictUnifier.get(foilPrefix, material, 2), "hP ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material)).output(foilPrefix, material, 4)).duration((int)material.getMass())).EUt(24)).circuitMeta(1)).buildAndRegister();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_FOIL)).output(foilPrefix, material, 4)).duration((int)material.getMass())).EUt(24)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_FOIL)).output(foilPrefix, material, 4)).duration((int)material.getMass())).EUt(24)).buildAndRegister();
        }
    }

    public static void processFineWire(OrePrefix fineWirePrefix, Material material, IngotProperty property) {
        if (!OreDictUnifier.get(OrePrefix.foil, material).func_190926_b()) {
            ModHandler.addShapelessRecipe(String.format("fine_wire_%s", material.toString()), OreDictUnifier.get(fineWirePrefix, material), Character.valueOf('x'), new UnificationEntry(OrePrefix.foil, material));
        }
        if (material.hasProperty(PropertyKey.WIRE)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(OrePrefix.wireGtSingle, material)).circuitMeta(1)).output(fineWirePrefix, material, 4)).duration((int)material.getMass() * 3 / 2)).EUt(GTValues.VA[0])).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).circuitMeta(3)).output(fineWirePrefix, material, 8)).duration((int)material.getMass() * 3)).EUt(GTValues.VA[0])).buildAndRegister();
    }

    public static void processGear(OrePrefix gearPrefix, Material material, DustProperty property) {
        ItemStack stack = OreDictUnifier.get(gearPrefix, material);
        if (gearPrefix == OrePrefix.gear && material.hasProperty(PropertyKey.INGOT)) {
            int voltageMultiplier = PartsRecipeHandler.getVoltageMultiplier(material);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getMass() * 5)).EUt(8 * voltageMultiplier)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 8)).notConsumable(MetaItems.SHAPE_MOLD_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getMass() * 10)).EUt(2 * voltageMultiplier)).buildAndRegister();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getMass() * 5)).EUt(8 * voltageMultiplier)).buildAndRegister();
            }
        }
        if (material.hasFluid()) {
            boolean isSmall = gearPrefix == OrePrefix.gearSmall;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(isSmall ? MetaItems.SHAPE_MOLD_GEAR_SMALL : MetaItems.SHAPE_MOLD_GEAR)).fluidInputs(material.getFluid(144 * (isSmall ? 1 : 4)))).outputs(stack)).duration(isSmall ? 20 : 100)).EUt(GTValues.VA[0])).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            if (gearPrefix == OrePrefix.gearSmall) {
                ModHandler.addShapedRecipe(String.format("small_gear_%s", material), OreDictUnifier.get(OrePrefix.gearSmall, material), " R ", "hPx", " R ", Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR_SMALL)).outputs(stack)).duration((int)material.getMass())).EUt(material.getBlastTemperature() >= 2800 ? 256 : 64)).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().duration((int)material.getMass())).EUt(GTValues.VA[1])).input(OrePrefix.ingot, material, 2)).notConsumable(MetaItems.SHAPE_MOLD_GEAR_SMALL.getStackForm())).output(OrePrefix.gearSmall, material)).buildAndRegister();
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR_SMALL)).outputs(stack)).duration((int)material.getMass())).EUt(material.getBlastTemperature() >= 2800 ? 256 : 64)).buildAndRegister();
                }
            } else {
                ModHandler.addShapedRecipe(String.format("gear_%s", material), stack, "RPR", "PwP", "RPR", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material));
            }
        }
    }

    public static void processLens(OrePrefix lensPrefix, Material material, GemProperty property) {
        ItemStack stack = OreDictUnifier.get(lensPrefix, material);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.plate, material)).output(OrePrefix.lens, material)).output(OrePrefix.dustSmall, material)).duration(1200)).EUt(120)).buildAndRegister();
        if (!OreDictUnifier.get(OrePrefix.gemExquisite, material).func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.gemExquisite, material)).output(OrePrefix.lens, material)).output(OrePrefix.dust, material, 2)).duration(2400)).EUt(30)).buildAndRegister();
        }
        if (material == Materials.Diamond) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)MarkerMaterials.Color.LightBlue);
        } else if (material == Materials.Ruby) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Red);
        } else if (material == Materials.Emerald) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Green);
        } else if (material == Materials.Glass) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens.name() + material.toCamelCaseString());
        } else {
            EnumDyeColor dyeColor = DyeUtil.determineDyeColor(material.getMaterialRGB());
            MarkerMaterial colorMaterial = (MarkerMaterial)MarkerMaterials.Color.COLORS.get((Object)dyeColor);
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)colorMaterial);
        }
    }

    public static void processPlate(OrePrefix platePrefix, Material material, DustProperty property) {
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_PLATE)).fluidInputs(material.getFluid(144))).outputs(OreDictUnifier.get(platePrefix, material))).duration(40)).EUt(GTValues.VA[0])).buildAndRegister();
        }
    }

    public static void processPlateDouble(OrePrefix doublePrefix, Material material, IngotProperty property) {
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ModHandler.addShapedRecipe(String.format("plate_double_%s", material), OreDictUnifier.get(doublePrefix, material), "h", "P", "P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().EUt(96)).duration((int)material.getMass() * 2)).input(OrePrefix.plate, material, 2)).output(doublePrefix, material)).circuitMeta(2)).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 2)).circuitMeta(2)).output(doublePrefix, material)).duration((int)material.getMass() * 2)).EUt(96)).buildAndRegister();
        }
    }

    public static void processPlateDense(OrePrefix orePrefix, Material material, IngotProperty property) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material, 9)).circuitMeta(9)).output(orePrefix, material)).duration((int)Math.max(material.getMass() * 9L, 1L))).EUt(96)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 9)).circuitMeta(9)).output(orePrefix, material)).duration((int)Math.max(material.getMass() * 9L, 1L))).EUt(96)).buildAndRegister();
    }

    public static void processRing(OrePrefix ringPrefix, Material material, IngotProperty property) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_RING)).outputs(OreDictUnifier.get(ringPrefix, material, 4))).duration((int)material.getMass() * 2)).EUt(6 * PartsRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ModHandler.addShapedRecipe(String.format("ring_%s", material), OreDictUnifier.get(ringPrefix, material), "h ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, material));
        } else {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_RING)).outputs(OreDictUnifier.get(ringPrefix, material, 4))).duration((int)material.getMass() * 2)).EUt(6 * PartsRecipeHandler.getVoltageMultiplier(material))).buildAndRegister();
        }
    }

    public static void processSpringSmall(OrePrefix springPrefix, Material material, IngotProperty property) {
        ModHandler.addShapedRecipe(String.format("spring_small_%s", material.toString()), OreDictUnifier.get(OrePrefix.springSmall, material), " s ", "fRx", Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().duration((int)(material.getMass() / 2L))).EUt(GTValues.VA[0])).input(OrePrefix.stick, material)).output(OrePrefix.springSmall, material, 2)).circuitMeta(1)).buildAndRegister();
    }

    public static void processSpring(OrePrefix springPrefix, Material material, IngotProperty property) {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.stickLong, material)).outputs(OreDictUnifier.get(OrePrefix.spring, material))).circuitMeta(1)).duration(200)).EUt(16)).buildAndRegister();
        ModHandler.addShapedRecipe(String.format("spring_%s", material.toString()), OreDictUnifier.get(OrePrefix.spring, material), " s ", "fRx", " R ", Character.valueOf('R'), new UnificationEntry(OrePrefix.stickLong, material));
    }

    public static void processRotor(OrePrefix rotorPrefix, Material material, IngotProperty property) {
        ItemStack stack = OreDictUnifier.get(rotorPrefix, material);
        ModHandler.addShapedRecipe(String.format("rotor_%s", material.toString()), stack, "ChC", "SRf", "CdC", Character.valueOf('C'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, material));
        if (material.hasFluid()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_ROTOR)).fluidInputs(material.getFluid(576))).outputs(GTUtility.copy(stack))).duration(120)).EUt(20)).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROTOR)).outputs(GTUtility.copy(stack))).duration((int)material.getMass() * 4)).EUt(material.getBlastTemperature() >= 2800 ? 256 : 64)).buildAndRegister();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROTOR)).outputs(GTUtility.copy(stack))).duration((int)material.getMass() * 4)).EUt(material.getBlastTemperature() >= 2800 ? 256 : 64)).buildAndRegister();
        }
    }

    public static void processStick(OrePrefix stickPrefix, Material material, DustProperty property) {
        if (material.hasProperty(PropertyKey.GEM) || material.hasProperty(PropertyKey.INGOT)) {
            Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(material.hasProperty(PropertyKey.GEM) ? OrePrefix.gem : OrePrefix.ingot, material)).duration((int)Math.max(material.getMass() * 2L, 1L))).EUt(16);
            if (ConfigHolder.recipes.harderRods) {
                ((RecipeBuilder)builder).output(OrePrefix.stick, material);
                ((RecipeBuilder)builder).output(OrePrefix.dustSmall, material, 2);
            } else {
                ((RecipeBuilder)builder).output(OrePrefix.stick, material, 2);
            }
            ((RecipeBuilder)builder).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
            ItemStack boltStack = OreDictUnifier.get(OrePrefix.bolt, material);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(stickPrefix, material)).outputs(GTUtility.copyAmount(4, boltStack))).duration((int)Math.max(material.getMass() * 2L, 1L))).EUt(4)).buildAndRegister();
            ModHandler.addShapedRecipe(String.format("bolt_saw_%s", material), GTUtility.copyAmount(2, boltStack), "s ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, material));
        }
    }

    public static void processLongStick(OrePrefix longStickPrefix, Material material, DustProperty property) {
        ItemStack stack = OreDictUnifier.get(longStickPrefix, material);
        ItemStack stickStack = OreDictUnifier.get(OrePrefix.stick, material);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(longStickPrefix, material)).outputs(GTUtility.copyAmount(2, stickStack))).duration((int)Math.max(material.getMass(), 1L))).EUt(4)).buildAndRegister();
        ModHandler.addShapedRecipe(String.format("stick_long_%s", material), GTUtility.copyAmount(2, stickStack), "s", "X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stickLong, material));
        if (material.hasProperty(PropertyKey.GEM)) {
            ModHandler.addShapedRecipe(String.format("stick_long_gem_flawless_%s", material), stickStack, "sf", "G ", Character.valueOf('G'), new UnificationEntry(OrePrefix.gemFlawless, material));
            ModHandler.addShapedRecipe(String.format("stick_long_gem_exquisite_%s", material), GTUtility.copyAmount(2, stickStack), "sf", "G ", Character.valueOf('G'), new UnificationEntry(OrePrefix.gemExquisite, material));
        }
        ModHandler.addShapedRecipe(String.format("stick_long_stick_%s", material), stack, "ShS", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material));
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(OrePrefix.stick, material, 2)).outputs(stack)).duration((int)Math.max(material.getMass(), 1L))).EUt(16)).buildAndRegister();
        if (material.hasProperty(PropertyKey.INGOT)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD_LONG)).outputs(stack)).duration((int)Math.max(material.getMass(), 1L))).EUt(64)).buildAndRegister();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD_LONG)).outputs(stack)).duration((int)Math.max(material.getMass(), 1L))).EUt(64)).buildAndRegister();
            }
        }
    }

    public static void processTurbine(OrePrefix toolPrefix, Material material, IngotProperty property) {
        ItemStack rotorStack = MetaItems.TURBINE_ROTOR.getStackForm();
        TurbineRotorBehavior.getInstanceFor(rotorStack);
        TurbineRotorBehavior.setPartMaterial(rotorStack, material);
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.turbineBlade, material, 8)).input(OrePrefix.stickLong, Materials.Magnalium)).outputs(rotorStack)).duration(200)).EUt(400)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().input(OrePrefix.plateDouble, material, 5)).input(OrePrefix.screw, material, 2)).outputs(OreDictUnifier.get(toolPrefix, material))).duration(20)).EUt(256)).buildAndRegister();
        ModHandler.addShapedRecipe(String.format("turbine_blade_%s", material), OreDictUnifier.get(toolPrefix, material), "PPP", "SPS", "fPd", Character.valueOf('P'), new UnificationEntry(OrePrefix.plateDouble, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material));
    }

    public static void processRound(OrePrefix roundPrefix, Material material, IngotProperty property) {
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ModHandler.addShapedRecipe(String.format("round_%s", material), OreDictUnifier.get(OrePrefix.round, material), "fN", "Nh", Character.valueOf('N'), new UnificationEntry(OrePrefix.nugget, material));
            ModHandler.addShapedRecipe(String.format("round_from_ingot_%s", material), OreDictUnifier.get(OrePrefix.round, material, 4), "fIh", Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().EUt(GTValues.VA[0])).duration(100)).input(OrePrefix.nugget, material)).output(OrePrefix.round, material)).buildAndRegister();
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() > 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

