/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.api.IBogoSortAPI;
import com.cleanroommc.bogosorter.api.ISortableContainer;
import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.api.SortType;
import com.cleanroommc.bogosorter.common.sort.ClientItemSortRule;
import com.cleanroommc.bogosorter.common.sort.ItemSortContainer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.core.mixin.ItemStackAccessor;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.Unmodifiable;

public class BogoSortAPI
implements IBogoSortAPI {
    public static final BogoSortAPI INSTANCE = new BogoSortAPI();
    public static final SortRule<ItemStack> EMPTY_ITEM_SORT_RULE = new SortRule<ItemStack>("empty", null, (o1, o2) -> 0){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    public static final NbtSortRule EMPTY_NBT_SORT_RULE = new NbtSortRule("empty", null, (o1, o2) -> 0){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private final Map<Class<?>, BiConsumer<Container, ISortingContextBuilder>> COMPAT_MAP = new Object2ObjectOpenHashMap();
    private final Map<String, SortRule<ItemStack>> itemSortRules = new Object2ObjectOpenHashMap();
    private final Map<String, NbtSortRule> nbtSortRules = new Object2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<SortRule<ItemStack>> itemSortRules2 = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<NbtSortRule> nbtSortRules2 = new Int2ObjectOpenHashMap();
    private final List<SortRule<ItemStack>> itemSortRuleList = new ArrayList<SortRule<ItemStack>>();
    private final List<NbtSortRule> nbtSortRuleList = new ArrayList<NbtSortRule>();
    public static final Hash.Strategy<ItemStack> ITEM_META_NBT_HASH_STRATEGY = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            return Objects.hash(o.func_77973_b(), o.func_77960_j(), o.func_77978_p(), BogoSortAPI.getItemAccessor(o).getCapNBT());
        }

        public boolean equals(ItemStack a, ItemStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.func_190926_b() && b.func_190926_b() || a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && Objects.equals(a.func_77978_p(), b.func_77978_p()) && Objects.equals(BogoSortAPI.getItemAccessor(a).getCapNBT(), BogoSortAPI.getItemAccessor(b).getCapNBT());
        }
    };
    public static final Hash.Strategy<ItemStack> ITEM_META_HASH_STRATEGY = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            return Objects.hash(o.func_77973_b(), o.func_77960_j());
        }

        public boolean equals(ItemStack a, ItemStack b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            return a.func_190926_b() && b.func_190926_b() || a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j();
        }
    };

    private BogoSortAPI() {
    }

    @Override
    public <T extends Container> void addCompat(Class<T> clazz, BiConsumer<T, ISortingContextBuilder> builder) {
        this.COMPAT_MAP.put(clazz, builder);
    }

    @Override
    public <T> void addCompatSimple(Class<T> clazz, BiConsumer<T, ISortingContextBuilder> builder) {
        if (!Container.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be an instance of Container!");
        }
        this.COMPAT_MAP.put(clazz, builder);
    }

    @Override
    public <T extends Container> void removeCompat(Class<T> clazz) {
        this.COMPAT_MAP.remove(clazz);
    }

    private static void validateKey(String key) {
        if (!key.matches("[A-Za-z_]+")) {
            throw new IllegalArgumentException("Key must only have letters and underscores!");
        }
    }

    @Override
    public void registerItemSortingRule(String key, SortType type, Comparator<ItemStack> itemComparator) {
        BogoSortAPI.validateKey(key);
        SortRule<ItemStack> sortRule = new SortRule<ItemStack>(key, type, itemComparator);
        this.itemSortRules.put(key, sortRule);
        this.itemSortRuleList.add(sortRule);
        this.itemSortRules2.put(sortRule.getSyncId(), sortRule);
    }

    @Override
    public void registerClientItemSortingRule(String key, SortType type, Comparator<ItemSortContainer> itemComparator) {
        BogoSortAPI.validateKey(key);
        ClientItemSortRule sortRule = new ClientItemSortRule(key, type, itemComparator);
        this.itemSortRules.put(key, sortRule);
        this.itemSortRuleList.add(sortRule);
        this.itemSortRules2.put(sortRule.getSyncId(), (Object)sortRule);
    }

    @Override
    public void registerNbtSortingRule(String key, String tagPath, Comparator<NBTBase> comparator) {
        BogoSortAPI.validateKey(key);
        NbtSortRule sortRule = new NbtSortRule(key, tagPath, comparator);
        this.nbtSortRules.put(key, sortRule);
        this.nbtSortRuleList.add(sortRule);
        this.nbtSortRules2.put(sortRule.getSyncId(), (Object)sortRule);
    }

    @Override
    public void registerNbtSortingRule(String key, String tagPath, int expectedType) {
        BogoSortAPI.validateKey(key);
        NbtSortRule sortRule = new NbtSortRule(key, tagPath, expectedType);
        this.nbtSortRules.put(key, sortRule);
        this.nbtSortRuleList.add(sortRule);
        this.nbtSortRules2.put(sortRule.getSyncId(), (Object)sortRule);
    }

    @Override
    public <T> void registerNbtSortingRule(String key, String tagPath, int expectedType, Comparator<T> comparator, Function<NBTBase, T> converter) {
        BogoSortAPI.validateKey(key);
        NbtSortRule sortRule = new NbtSortRule(key, tagPath, expectedType, comparator, converter);
        this.nbtSortRules.put(key, sortRule);
        this.nbtSortRuleList.add(sortRule);
        this.nbtSortRules2.put(sortRule.getSyncId(), (Object)sortRule);
    }

    public <T extends Container> BiConsumer<T, ISortingContextBuilder> getBuilder(Container container) {
        BiConsumer<Container, ISortingContextBuilder> builder = this.COMPAT_MAP.get(container.getClass());
        return builder == null ? null : builder;
    }

    public @Unmodifiable List<NbtSortRule> getNbtSortRuleList() {
        return Collections.unmodifiableList(this.nbtSortRuleList);
    }

    public @Unmodifiable List<SortRule<ItemStack>> getItemSortRuleList() {
        return Collections.unmodifiableList(this.itemSortRuleList);
    }

    public SortRule<ItemStack> getItemSortRule(String key) {
        return this.itemSortRules.getOrDefault(key, EMPTY_ITEM_SORT_RULE);
    }

    public SortRule<ItemStack> getItemSortRule(int syncId) {
        return (SortRule)this.itemSortRules2.get(syncId);
    }

    public NbtSortRule getNbtSortRule(int syncId) {
        return (NbtSortRule)this.nbtSortRules2.get(syncId);
    }

    public NbtSortRule getNbtSortRule(String key) {
        return this.nbtSortRules.getOrDefault(key, EMPTY_NBT_SORT_RULE);
    }

    public static boolean isValidSortable(Container container) {
        return container instanceof ISortableContainer || BogoSortAPI.INSTANCE.COMPAT_MAP.containsKey(container.getClass());
    }

    public static boolean isPlayerSlot(Slot slot) {
        IItemHandler iItemHandler;
        if (slot == null) {
            return false;
        }
        if (slot.field_75224_c instanceof InventoryPlayer) {
            return slot.getSlotIndex() >= 9 && slot.getSlotIndex() < 36;
        }
        if (slot instanceof SlotItemHandler && ((iItemHandler = ((SlotItemHandler)slot).getItemHandler()) instanceof PlayerMainInvWrapper || iItemHandler instanceof PlayerInvWrapper)) {
            return slot.getSlotIndex() >= 9 && slot.getSlotIndex() < 36;
        }
        return false;
    }

    public static boolean isPlayerOrHotbarSlot(Slot slot) {
        IItemHandler iItemHandler;
        if (slot == null) {
            return false;
        }
        if (slot.field_75224_c instanceof InventoryPlayer) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        if (slot instanceof SlotItemHandler && ((iItemHandler = ((SlotItemHandler)slot).getItemHandler()) instanceof PlayerMainInvWrapper || iItemHandler instanceof PlayerInvWrapper)) {
            return slot.getSlotIndex() >= 0 && slot.getSlotIndex() < 36;
        }
        return false;
    }

    public static ItemStackAccessor getItemAccessor(ItemStack itemStack) {
        return (ItemStackAccessor)itemStack;
    }
}

