/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.ClientEventHandler;
import com.cleanroommc.bogosorter.common.HotbarSwap;
import com.cleanroommc.bogosorter.common.OreDictHelper;
import com.cleanroommc.bogosorter.common.SortConfigChangeEvent;
import com.cleanroommc.bogosorter.common.config.BogoSortCommandTree;
import com.cleanroommc.bogosorter.common.config.PlayerConfig;
import com.cleanroommc.bogosorter.common.config.Serializer;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.network.NetworkUtils;
import com.cleanroommc.bogosorter.common.refill.RefillHandler;
import com.cleanroommc.bogosorter.common.sort.DefaultRules;
import com.cleanroommc.bogosorter.compat.DefaultCompat;
import com.cleanroommc.modularui.keybind.KeyBindAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="bogosorter", name="Inventory Bogo Sorter", version="1.2.6", dependencies="required-after:modularui@[2.0.2,);required-after:mixinbooter@[4.2,)", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="bogosorter")
public class BogoSorter {
    public static final String ID = "bogosorter";
    public static final String NAME = "Inventory Bogo Sorter";
    public static final String VERSION = "1.2.6";
    public static final Logger LOGGER = LogManager.getLogger((String)"bogosorter");
    private static boolean anyGtLoaded = false;
    private static boolean tconstructLoaded = false;
    private static boolean anyIc2Loaded = false;
    private static boolean ic2ClassicLoaded = false;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        anyGtLoaded = Loader.isModLoaded((String)"gregtech");
        tconstructLoaded = Loader.isModLoaded((String)"tconstruct");
        anyIc2Loaded = Loader.isModLoaded((String)"ic2");
        if (anyIc2Loaded) {
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get("ic2");
            ic2ClassicLoaded = container.getName().endsWith("Classic");
        }
        NetworkHandler.init();
        OreDictHelper.init();
        DefaultRules.init(BogoSortAPI.INSTANCE);
        DefaultCompat.init(BogoSortAPI.INSTANCE);
        Serializer.loadConfig();
        MinecraftForge.EVENT_BUS.register(RefillHandler.class);
        if (NetworkUtils.isDedicatedClient()) {
            MinecraftForge.EVENT_BUS.post((Event)new SortConfigChangeEvent());
            PlayerConfig.syncToServer();
            MinecraftForge.EVENT_BUS.register(HotbarSwap.class);
        }
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        if (NetworkUtils.isDedicatedClient()) {
            ClientRegistry.registerKeyBinding((KeyBinding)ClientEventHandler.configGuiKey);
            ClientRegistry.registerKeyBinding((KeyBinding)ClientEventHandler.sortKey);
            KeyBindAPI.forceCheckKeyBind((KeyBinding)ClientEventHandler.configGuiKey);
            KeyBindAPI.forceCheckKeyBind((KeyBinding)ClientEventHandler.sortKey);
            KeyBindAPI.setCompatible((KeyBinding)ClientEventHandler.sortKey, (KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74322_I);
        }
    }

    @Mod.EventHandler
    public void onServerLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BogoSortCommandTree());
    }

    public static boolean isAnyGtLoaded() {
        return anyGtLoaded;
    }

    public static boolean isGTCELoaded() {
        if (anyGtLoaded) {
            // empty if block
        }
        return false;
    }

    public static boolean isGTCEuLoaded() {
        return anyGtLoaded;
    }

    public static boolean isTConstructLoaded() {
        return tconstructLoaded;
    }

    public static boolean isAnyIc2Loaded() {
        return anyIc2Loaded;
    }

    public static boolean isIc2ClassicLoaded() {
        return anyIc2Loaded && ic2ClassicLoaded;
    }

    public static boolean isIc2ExpLoaded() {
        return anyIc2Loaded && !ic2ClassicLoaded;
    }
}

