/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.ShortcutHandler;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.config.ConfigGui;
import com.cleanroommc.bogosorter.common.network.CSort;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.manager.GuiManager;
import com.cleanroommc.modularui.screen.ModularScreen;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(modid="bogosorter", value={Side.CLIENT})
public class ClientEventHandler {
    public static final List<ItemStack> allItems = new ArrayList<ItemStack>();
    public static final KeyBinding configGuiKey = new KeyBinding("key.sort_config", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, 37, "key.categories.bogosorter");
    public static final KeyBinding sortKey = new KeyBinding("key.sort", (IKeyConflictContext)KeyConflictContext.GUI, -98, "key.categories.bogosorter");
    private static long timeConfigGui = 0L;
    private static long timeSort = 0L;
    private static long timeShortcut = 0L;
    private static GuiScreen previousScreen;

    private static void shortcutAction() {
        timeShortcut = Minecraft.func_71386_F();
    }

    private static boolean canDoShortcutAction() {
        return Minecraft.func_71386_F() - timeShortcut > 50L;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        ClientEventHandler.handleInput(null);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.MouseInputEvent event) {
        ClientEventHandler.handleInput(null);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onGuiKeyInput(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (!(event.getGui() instanceof GuiContainer)) {
            return;
        }
        if (ClientEventHandler.handleInput((GuiContainer)event.getGui())) {
            event.setCanceled(true);
            return;
        }
        if (FMLLaunchHandler.isDeobfuscatedEnvironment()) {
            if (Keyboard.isKeyDown((int)79)) {
                Slot slot = ClientEventHandler.getSlot(event.getGui());
                SortHandler sortHandler = ClientEventHandler.createSortHandler(event.getGui(), slot);
                if (sortHandler == null) {
                    return;
                }
                sortHandler.clearAllItems(slot);
                return;
            }
            if (Keyboard.isKeyDown((int)80)) {
                if (allItems.isEmpty()) {
                    for (Item item : ForgeRegistries.ITEMS) {
                        NonNullList subItems = NonNullList.func_191196_a();
                        item.func_150895_a(CreativeTabs.field_78027_g, subItems);
                        allItems.addAll((Collection<ItemStack>)subItems);
                    }
                }
                Iterator slot = ClientEventHandler.getSlot(event.getGui());
                SortHandler sortHandler = ClientEventHandler.createSortHandler(event.getGui(), (Slot)slot);
                if (sortHandler == null) {
                    return;
                }
                sortHandler.randomizeItems((Slot)slot);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMouseInput(GuiScreenEvent.MouseInputEvent.Pre event) {
        if (event.getGui() instanceof GuiContainer && ClientEventHandler.handleInput((GuiContainer)event.getGui())) {
            event.setCanceled(true);
        }
    }

    public static boolean handleInput(@Nullable GuiContainer container) {
        long t;
        if (container != null && container.func_193976_p()) {
            return false;
        }
        if (container != null && ClientEventHandler.canDoShortcutAction()) {
            if (Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1)) {
                if (Keyboard.isKeyDown((int)57) && !GuiScreen.func_175283_s() && ShortcutHandler.moveAllItems(container, false)) {
                    ClientEventHandler.shortcutAction();
                    return true;
                }
                if (!Keyboard.isKeyDown((int)57) && GuiScreen.func_175283_s() && ShortcutHandler.moveAllItems(container, true)) {
                    ClientEventHandler.shortcutAction();
                    return true;
                }
            }
            if (GuiScreen.func_146271_m()) {
                if (Mouse.isButtonDown((int)0) && !Mouse.isButtonDown((int)1) && ShortcutHandler.moveSingleItem(container, false)) {
                    ClientEventHandler.shortcutAction();
                    return true;
                }
                if (Mouse.isButtonDown((int)1) && !Mouse.isButtonDown((int)0) && ShortcutHandler.moveSingleItem(container, true)) {
                    ClientEventHandler.shortcutAction();
                    return true;
                }
            }
            if (ClientEventHandler.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_74316_C)) {
                if (!Keyboard.isKeyDown((int)57) && GuiScreen.func_175283_s() && ShortcutHandler.dropItems(container, true)) {
                    ClientEventHandler.shortcutAction();
                    return true;
                }
                if (Keyboard.isKeyDown((int)57) && !GuiScreen.func_175283_s() && ShortcutHandler.dropItems(container, false)) {
                    ClientEventHandler.shortcutAction();
                    return true;
                }
            }
        }
        boolean c = configGuiKey.func_151468_f();
        boolean s = sortKey.func_151468_f();
        if (c && (t = Minecraft.func_71386_F()) - timeConfigGui > 500L) {
            if (ConfigGui.wasOpened) {
                Minecraft.func_71410_x().func_147108_a(previousScreen);
                previousScreen = null;
            } else {
                previousScreen = Minecraft.func_71410_x().field_71462_r;
                GuiManager.openClientUI((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ModularScreen)new ConfigGui());
            }
            timeConfigGui = t;
            return true;
        }
        if (container != null && s && (t = Minecraft.func_71386_F()) - timeSort > 500L) {
            Slot slot = ClientEventHandler.getSlot((GuiScreen)container);
            if (slot == null || !ClientEventHandler.canSort(slot)) {
                return false;
            }
            if (!ClientEventHandler.sort((GuiScreen)container, slot)) {
                return false;
            }
            timeSort = t;
            return true;
        }
        return false;
    }

    private static boolean canSort(Slot slot) {
        return !Minecraft.func_71410_x().field_71439_g.func_184812_l_() || sortKey.getKeyModifier().isActive() != Minecraft.func_71410_x().field_71474_y.field_74322_I.getKeyModifier().isActive() || sortKey.func_151463_i() != Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151463_i() || slot.func_75211_c().func_190926_b() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b();
    }

    private static boolean isKeyDown(KeyBinding key) {
        return key.getKeyModifier().isActive() && (key.func_151463_i() < 0 ? Mouse.isButtonDown((int)(key.func_151463_i() + 100)) : Keyboard.isKeyDown((int)key.func_151463_i()));
    }

    public static boolean isSortableContainer(GuiScreen screen) {
        return screen instanceof GuiContainer && BogoSortAPI.isValidSortable(((GuiContainer)screen).field_147002_h);
    }

    public static <T extends Container> T getSortableContainer(GuiScreen screen) {
        return (T)((GuiContainer)screen).field_147002_h;
    }

    @Nullable
    public static Slot getSlot(GuiScreen guiScreen) {
        if (guiScreen instanceof GuiContainer) {
            return ((GuiContainer)guiScreen).getSlotUnderMouse();
        }
        return null;
    }

    public static boolean sort(GuiScreen guiScreen, @Nullable Slot slot) {
        if (slot != null && guiScreen instanceof GuiContainer) {
            Container container = ((GuiContainer)guiScreen).field_147002_h;
            boolean player = BogoSortAPI.isPlayerSlot(slot);
            if (!player && !ClientEventHandler.isSortableContainer(guiScreen)) {
                return false;
            }
            List<SortRule<ItemStack>> sortRules = BogoSorterConfig.sortRules;
            boolean color = sortRules.contains(BogoSortAPI.INSTANCE.getItemSortRule("color"));
            boolean name = sortRules.contains(BogoSortAPI.INSTANCE.getItemSortRule("display_name"));
            NetworkHandler.sendToServer(new CSort(ClientEventHandler.createSortData(container, slot, player, color, name), BogoSorterConfig.sortRules, BogoSorterConfig.nbtSortRules, slot.field_75222_d, player));
            Interactable.playButtonClickSound();
            return true;
        }
        return false;
    }

    public static List<ClientSortData> createSortData(Container container, Slot slot, boolean player, boolean color, boolean name) {
        if (!color && !name) {
            return Collections.emptyList();
        }
        GuiSortingContext context = GuiSortingContext.create(container, player);
        Slot[][] slots = context.getSlotGroup(slot.field_75222_d);
        if (slots == null) {
            return Collections.emptyList();
        }
        ArrayList<ClientSortData> data = new ArrayList<ClientSortData>();
        Slot[][] slotArray = slots;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] slotRow;
            for (Slot slot1 : slotRow = slotArray[i]) {
                data.add(ClientSortData.of(slot1, color, name));
            }
        }
        return data;
    }

    public static SortHandler createSortHandler(GuiScreen guiScreen, @Nullable Slot slot) {
        if (slot != null && guiScreen instanceof GuiContainer) {
            Container container = ((GuiContainer)guiScreen).field_147002_h;
            boolean player = BogoSortAPI.isPlayerSlot(slot);
            if (!player && !ClientEventHandler.isSortableContainer(guiScreen)) {
                return null;
            }
            return new SortHandler((EntityPlayer)Minecraft.func_71410_x().field_71439_g, container, player, (Int2ObjectMap<ClientSortData>)Int2ObjectMaps.emptyMap());
        }
        return null;
    }
}

