/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.common.network.CDropSlots;
import com.cleanroommc.bogosorter.common.network.CShortcut;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShortcutHandler {
    public static boolean moveSingleItem(GuiContainer guiContainer, boolean emptySlot) {
        Slot slot = guiContainer.getSlotUnderMouse();
        if (slot == null || slot.func_75211_c().func_190926_b()) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(emptySlot ? CShortcut.Type.MOVE_SINGLE_EMPTY : CShortcut.Type.MOVE_SINGLE, slot.field_75222_d));
        return true;
    }

    public static boolean moveSingleItem(EntityPlayer player, Container container, Slot slot, boolean emptySlot) {
        if (slot == null || slot.func_75211_c().func_190926_b()) {
            return false;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack toInsert = stack.func_77946_l();
        toInsert.func_190920_e(1);
        if (BogoSortAPI.isValidSortable(container)) {
            Slot[][] otherSlots;
            GuiSortingContext sortingContext = GuiSortingContext.create(container);
            Slot[][] slots = sortingContext.getSlotGroup(slot.field_75222_d);
            Slot[][] slotArray = otherSlots = BogoSortAPI.isPlayerOrHotbarSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
            if (otherSlots == null || slots == otherSlots) {
                return false;
            }
            toInsert = emptySlot ? ShortcutHandler.insertToSlots(otherSlots, toInsert, true) : ShortcutHandler.insertToSlots(otherSlots, toInsert);
        } else {
            ArrayList<Slot> otherSlots = new ArrayList<Slot>();
            boolean isPlayer = BogoSortAPI.isPlayerOrHotbarSlot(slot);
            for (Slot slot1 : container.field_75151_b) {
                if (isPlayer == BogoSortAPI.isPlayerOrHotbarSlot(slot1)) continue;
                otherSlots.add(slot1);
            }
            if (!emptySlot && toInsert.func_77985_e()) {
                toInsert = ShortcutHandler.insertToSlots(otherSlots, toInsert, false);
            }
            if (!toInsert.func_190926_b()) {
                toInsert = ShortcutHandler.insertToSlots(otherSlots, toInsert, true);
            }
        }
        if (toInsert.func_190926_b()) {
            toInsert = stack.func_77946_l();
            toInsert.func_190920_e(1);
            slot.func_75209_a(1);
            slot.func_190901_a(player, toInsert);
            return true;
        }
        return false;
    }

    public static boolean moveAllItems(GuiContainer guiContainer, boolean sameItemOnly) {
        Container container = guiContainer.field_147002_h;
        Slot slot = guiContainer.getSlotUnderMouse();
        if (slot == null || !BogoSortAPI.isValidSortable(container) || sameItemOnly && slot.func_75211_c().func_190926_b()) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(sameItemOnly ? CShortcut.Type.MOVE_ALL_SAME : CShortcut.Type.MOVE_ALL, slot.field_75222_d));
        return true;
    }

    public static boolean moveAllItems(EntityPlayer player, Container container, Slot slot, boolean sameItemOnly) {
        Slot[][] otherSlots;
        if (slot == null || !BogoSortAPI.isValidSortable(container)) {
            return false;
        }
        ItemStack stack = slot.func_75211_c().func_77946_l();
        if (sameItemOnly && stack.func_190926_b()) {
            return false;
        }
        GuiSortingContext sortingContext = GuiSortingContext.create(container);
        Slot[][] slots = sortingContext.getSlotGroup(slot.field_75222_d);
        Slot[][] slotArray = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
        if (slots == null || otherSlots == null || slots == otherSlots) {
            return false;
        }
        Slot[][] slotArray2 = slots;
        int n = slotArray2.length;
        for (int i = 0; i < n; ++i) {
            Slot[] slotRow;
            for (Slot slot1 : slotRow = slotArray2[i]) {
                ItemStack stackInSlot = slot1.func_75211_c();
                ItemStack copy = stackInSlot.func_77946_l();
                if (stackInSlot.func_190926_b() || sameItemOnly && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) continue;
                ItemStack remainder = ShortcutHandler.insertToSlots(otherSlots, copy);
                int inserted = stackInSlot.func_190916_E() - remainder.func_190916_E();
                if (inserted <= 0) continue;
                copy = stackInSlot.func_77946_l();
                stackInSlot.func_190920_e(inserted);
                slot1.func_75209_a(inserted);
                slot1.func_190901_a(player, copy);
            }
        }
        return true;
    }

    public static boolean dropItems(GuiContainer guiContainer, boolean onlySameType) {
        Container container = guiContainer.field_147002_h;
        Slot slot = guiContainer.getSlotUnderMouse();
        if (slot == null) {
            return false;
        }
        boolean player = BogoSortAPI.isPlayerSlot(slot);
        if (!player && !BogoSortAPI.isValidSortable(container)) {
            return false;
        }
        ItemStack item = slot.func_75211_c();
        if (onlySameType && item.func_190926_b()) {
            return false;
        }
        Slot[][] slots = GuiSortingContext.create(container, player).getSlotGroup(slot.field_75222_d);
        if (slots == null) {
            return false;
        }
        IntArrayList slotsToDrop = new IntArrayList();
        Slot[][] slotArray = slots;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] slotRow;
            for (Slot slot1 : slotRow = slotArray[i]) {
                ItemStack stack = slot1.func_75211_c();
                if (stack.func_190926_b() || onlySameType && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)item)) continue;
                slotsToDrop.add(slot1.field_75222_d);
            }
        }
        if (slotsToDrop.isEmpty()) {
            return false;
        }
        NetworkHandler.sendToServer(new CDropSlots((IntList)slotsToDrop));
        return true;
    }

    private static ItemStack insertToSlots(Slot[][] slots, ItemStack stack) {
        if (!stack.func_77985_e()) {
            return ShortcutHandler.insertToSlots(slots, stack, true);
        }
        if (!(stack = ShortcutHandler.insertToSlots(slots, stack, false)).func_190926_b()) {
            stack = ShortcutHandler.insertToSlots(slots, stack, true);
        }
        return stack;
    }

    private static ItemStack insertToSlots(Slot[][] slots, ItemStack stack, boolean emptyOnly) {
        Slot[][] slotArray = slots;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] slotRow;
            for (Slot slot : slotRow = slotArray[i]) {
                if (!(stack = ShortcutHandler.insert(slot, stack, emptyOnly)).func_190926_b()) continue;
                return stack;
            }
        }
        return stack;
    }

    private static ItemStack insertToSlots(List<Slot> slots, ItemStack stack, boolean emptyOnly) {
        for (Slot slot : slots) {
            stack = ShortcutHandler.insert(slot, stack, emptyOnly);
            if (!stack.func_190926_b()) continue;
            return stack;
        }
        return stack;
    }

    private static ItemStack insert(Slot slot, ItemStack stack, boolean emptyOnly) {
        ItemStack stackInSlot = slot.func_75211_c();
        if (emptyOnly) {
            if (!stackInSlot.func_190926_b() || !slot.func_75214_a(stack)) {
                return stack;
            }
            int amount = Math.min(stack.func_190916_E(), slot.func_178170_b(stack));
            if (amount <= 0) {
                return stack;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(amount);
            stack.func_190918_g(amount);
            slot.func_75215_d(newStack);
            return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        }
        if (!stackInSlot.func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
            int amount = Math.min(slot.func_178170_b(stackInSlot), Math.min(stack.func_190916_E(), stackInSlot.func_77976_d() - stackInSlot.func_190916_E()));
            if (amount <= 0) {
                return stack;
            }
            stack.func_190918_g(amount);
            stackInSlot.func_190917_f(amount);
            return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        }
        return stack;
    }
}

