/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.api;

import com.cleanroommc.bogosorter.api.SortType;
import java.util.Comparator;

public class SortRule<T>
implements Comparator<T> {
    private static int nextId = 0;
    private final SortType type;
    private final String key;
    private final Comparator<T> comparator;
    private boolean inverted = false;
    private final int syncId;

    public SortRule(String key, SortType type, Comparator<T> comparator) {
        this.type = type;
        this.key = key;
        this.comparator = comparator;
        this.syncId = nextId++;
    }

    public String getKey() {
        return this.key;
    }

    public String getNameLangKey() {
        return "bogosort.sortrules.item." + this.key + ".name";
    }

    public String getDescriptionLangKey() {
        return "bogosort.sortrules.item." + this.key + ".description";
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public int getSyncId() {
        return this.syncId;
    }

    public boolean isEmpty() {
        return false;
    }

    @Override
    public int compare(T o1, T o2) {
        return this.inverted ? this.comparator.compare(o2, o1) : this.comparator.compare(o1, o2);
    }

    public String toString() {
        return "SortRule{key='" + this.key + '\'' + '}';
    }
}

