/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common;

import com.cleanroommc.bogosorter.common.network.CDropItems;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.Nullable;

public class McUtils {
    public static void dropItem(ItemStack stack, World world, double x, double y, double z) {
        McUtils.dropItem(stack, world, x, y, z, null, false, 10);
    }

    public static void dropItem(ItemStack stack, World world, double x, double y, double z, @Nullable String thrower, boolean noDespawn, int pickUpDelay) {
        if (!(world.field_72995_K || stack.func_190926_b() || world.restoringBlockSnapshots)) {
            double d0 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(world, x + d0, y + d1, z + d2, stack);
            entityitem.func_174867_a(pickUpDelay);
            entityitem.func_145799_b(thrower);
            if (noDespawn) {
                entityitem.func_174873_u();
            }
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void giveItemsToPlayer(EntityPlayer player, List<ItemStack> items) {
        if (player == null || items.isEmpty()) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            McUtils.giveItemsToPlayerServer(player, items);
            return;
        }
        CDropItems packet = new CDropItems(items);
        NetworkHandler.sendToServer(packet);
    }

    public static void giveItemsToPlayerServer(EntityPlayer player, List<ItemStack> items) {
        if (player == null || items.isEmpty() || player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerMainInvWrapper itemHandler = new PlayerMainInvWrapper(player.field_71071_by);
        items.removeIf(item -> {
            ItemStack remainder = McUtils.insertToPlayer(itemHandler, item, false);
            return remainder.func_190926_b();
        });
        for (ItemStack item2 : items) {
            player.func_146097_a(item2, false, false);
        }
    }

    public static ItemStack insertToPlayer(PlayerMainInvWrapper itemHandler, ItemStack stack, boolean simulate) {
        ItemStack slot;
        if (itemHandler == null || stack.func_190926_b()) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return McUtils.insertItem((IItemHandler)itemHandler, stack, simulate, 9);
        }
        int sizeInventory = itemHandler.getSlots();
        for (int i = 9; !(i >= sizeInventory || ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)(slot = itemHandler.getStackInSlot(i)), (ItemStack)stack) && (stack = itemHandler.insertItem(i, stack, simulate)).func_190926_b()); ++i) {
        }
        return McUtils.insertItem((IItemHandler)itemHandler, stack, simulate, 9);
    }

    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, int startSlot) {
        if (dest == null || stack.func_190926_b()) {
            return stack;
        }
        for (int i = startSlot; i < dest.getSlots(); ++i) {
            if (!(stack = dest.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }
}

