/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.config;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.BogoSorter;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.HotbarSwap;
import com.cleanroommc.bogosorter.common.config.JsonHelper;
import com.cleanroommc.bogosorter.common.config.PlayerConfig;
import com.cleanroommc.bogosorter.common.config.Serializer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BogoSorterConfig {
    public static final List<SortRule<ItemStack>> sortRules = new ArrayList<SortRule<ItemStack>>();
    public static final List<NbtSortRule> nbtSortRules = new ArrayList<NbtSortRule>();
    public static final Object2IntOpenHashMap<String> ORE_PREFIXES = new Object2IntOpenHashMap();
    public static final List<String> ORE_PREFIXES_LIST = new ArrayList<String>();

    @SideOnly(value=Side.CLIENT)
    public static void save(JsonObject json) {
        JsonObject ruleJson;
        PlayerConfig playerConfig = PlayerConfig.getClient();
        JsonObject general = new JsonObject();
        general.addProperty("enableAutoRefill", Boolean.valueOf(playerConfig.enableAutoRefill));
        general.addProperty("refillDmgThreshold", (Number)playerConfig.autoRefillDamageThreshold);
        general.addProperty("enableHotbarSwap", Boolean.valueOf(HotbarSwap.isEnabled()));
        json.add("General", (JsonElement)general);
        JsonArray jsonRules = new JsonArray();
        for (SortRule<ItemStack> sortRule : sortRules) {
            if (sortRule == BogoSortAPI.EMPTY_ITEM_SORT_RULE) continue;
            ruleJson = new JsonObject();
            ruleJson.addProperty("name", sortRule.getKey());
            ruleJson.addProperty("inverted", Boolean.valueOf(sortRule.isInverted()));
            jsonRules.add((JsonElement)ruleJson);
        }
        json.add("ItemSortRules", (JsonElement)jsonRules);
        jsonRules = new JsonArray();
        for (NbtSortRule nbtSortRule : nbtSortRules) {
            if (nbtSortRule == BogoSortAPI.EMPTY_NBT_SORT_RULE) continue;
            ruleJson = new JsonObject();
            ruleJson.addProperty("name", nbtSortRule.getKey());
            ruleJson.addProperty("inverted", Boolean.valueOf(nbtSortRule.isInverted()));
            jsonRules.add((JsonElement)ruleJson);
        }
        json.add("NbtSortRules", (JsonElement)jsonRules);
    }

    @SideOnly(value=Side.CLIENT)
    public static void load(JsonObject json) {
        NbtSortRule rule;
        String key;
        boolean inverted;
        JsonArray sortRules;
        PlayerConfig playerConfig = PlayerConfig.getClient();
        if (json.has("General")) {
            JsonObject general = json.getAsJsonObject("General");
            playerConfig.enableAutoRefill = general.get("enableAutoRefill").getAsBoolean();
            playerConfig.autoRefillDamageThreshold = general.get("refillDmgThreshold").getAsShort();
            HotbarSwap.setEnabled(JsonHelper.getBoolean(general, true, "enableHotbarSwap"));
        }
        BogoSorterConfig.sortRules.clear();
        if (json.has("ItemSortRules")) {
            sortRules = json.getAsJsonArray("ItemSortRules");
            for (JsonElement jsonElement : sortRules) {
                inverted = false;
                if (jsonElement.isJsonObject()) {
                    key = JsonHelper.getString(jsonElement.getAsJsonObject(), "", "key", "name");
                    inverted = JsonHelper.getBoolean(jsonElement.getAsJsonObject(), false, "inverted", "ascending", "asc");
                } else {
                    key = jsonElement.getAsString();
                }
                rule = BogoSortAPI.INSTANCE.getItemSortRule(key);
                if (rule.isEmpty()) {
                    BogoSorter.LOGGER.error("Could not find item sort rule with key '{}'.", (Object)key);
                    continue;
                }
                rule.setInverted(inverted);
                BogoSorterConfig.sortRules.add(rule);
            }
        }
        nbtSortRules.clear();
        if (json.has("NbtSortRules")) {
            sortRules = json.getAsJsonArray("NbtSortRules");
            for (JsonElement jsonElement : sortRules) {
                inverted = false;
                if (jsonElement.isJsonObject()) {
                    key = JsonHelper.getString(jsonElement.getAsJsonObject(), "", "key", "name");
                    inverted = JsonHelper.getBoolean(jsonElement.getAsJsonObject(), false, "inverted", "ascending", "asc");
                } else {
                    key = jsonElement.getAsString();
                }
                rule = BogoSortAPI.INSTANCE.getNbtSortRule(key);
                if (rule.isEmpty()) {
                    BogoSorter.LOGGER.error("Could not find nbt sort rule with key '{}'.", (Object)key);
                    continue;
                }
                rule.setInverted(inverted);
                nbtSortRules.add(rule);
            }
        }
    }

    public static void saveOrePrefixes(JsonObject json) {
        json.addProperty("_comment", "Setting this to true will recreate this entire file on next start");
        json.addProperty("reload", Boolean.valueOf(false));
        JsonArray orePrefixes = new JsonArray();
        json.add("orePrefixes", (JsonElement)orePrefixes);
        for (String orePrefix : ORE_PREFIXES_LIST) {
            orePrefixes.add(orePrefix);
        }
    }

    public static void loadOrePrefixes(JsonObject json) {
        if (json.has("reload") && json.get("reload").getAsBoolean()) {
            Serializer.saveOrePrefixes();
            return;
        }
        if (json.has("orePrefixes")) {
            ORE_PREFIXES.clear();
            ORE_PREFIXES_LIST.clear();
            int i = 0;
            for (JsonElement jsonElement : json.getAsJsonArray("orePrefixes")) {
                if (!jsonElement.isJsonPrimitive()) continue;
                String orePrefix = jsonElement.getAsString();
                ORE_PREFIXES.put((Object)orePrefix, i++);
                ORE_PREFIXES_LIST.add(orePrefix);
            }
        }
    }

    public static void loadDefaultRules() {
        String[] itemRules = new String[]{"mod", "material", "ore_prefix", "id", "meta", "nbt_has", "nbt_rules"};
        String[] nbtRules = new String[]{"enchantment", "enchantment_book", "potion", "gt_circ_config", "gt_item_damage"};
        sortRules.addAll(Arrays.stream(itemRules).map(BogoSortAPI.INSTANCE::getItemSortRule).filter(rule -> rule != BogoSortAPI.EMPTY_ITEM_SORT_RULE).collect(Collectors.toList()));
        nbtSortRules.addAll(Arrays.stream(nbtRules).map(BogoSortAPI.INSTANCE::getNbtSortRule).filter(rule -> rule != BogoSortAPI.EMPTY_NBT_SORT_RULE).collect(Collectors.toList()));
    }
}

