/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.config;

import com.cleanroommc.bogosorter.common.network.CConfigSync;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.network.NetworkUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class PlayerConfig {
    private static final Map<EntityPlayerMP, PlayerConfig> playerConfig = new Object2ObjectOpenHashMap();
    private static final PlayerConfig CLIENT = new PlayerConfig();
    public boolean enableAutoRefill = true;
    public int autoRefillDamageThreshold = 1;

    public static PlayerConfig get(@NotNull EntityPlayer player) {
        if (NetworkUtils.isDedicatedClient()) {
            return CLIENT;
        }
        if (player instanceof EntityPlayerMP) {
            return playerConfig.computeIfAbsent((EntityPlayerMP)player, key -> new PlayerConfig());
        }
        throw new IllegalStateException("Could net get player config for " + player.func_70005_c_());
    }

    @SideOnly(value=Side.CLIENT)
    public static PlayerConfig getClient() {
        return CLIENT;
    }

    public void writePacket(PacketBuffer buffer) {
        buffer.writeBoolean(this.enableAutoRefill);
        buffer.func_150787_b(this.autoRefillDamageThreshold);
    }

    public void readPacket(PacketBuffer buffer) {
        this.enableAutoRefill = buffer.readBoolean();
        this.autoRefillDamageThreshold = buffer.func_150792_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncToServer() {
        NetworkHandler.sendToServer(new CConfigSync());
    }
}

