/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.network;

import com.cleanroommc.bogosorter.BogoSorter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    public static final Consumer<PacketBuffer> EMPTY_PACKET = buffer -> {};

    public static boolean isDedicatedClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    public static boolean isClient(EntityPlayer player) {
        if (player == null) {
            throw new NullPointerException("Can't get side of null player!");
        }
        return player.field_70170_p == null ? player instanceof EntityPlayerSP : player.field_70170_p.field_72995_K;
    }

    public static void writeSlotPos(PacketBuffer buf, Container container) {
        buf.func_150787_b(container.field_75151_b.size());
        for (Slot slot : container.field_75151_b) {
            buf.func_150787_b(slot.field_75222_d);
            buf.func_150787_b(slot.field_75223_e);
            buf.func_150787_b(slot.field_75221_f);
        }
    }

    public static void readSlotPos(PacketBuffer buf, Container container) {
        int n = buf.func_150792_a();
        for (int i = 0; i < n; ++i) {
            Slot slot = container.func_75139_a(buf.func_150792_a());
            slot.field_75223_e = buf.func_150792_a();
            slot.field_75221_f = buf.func_150792_a();
        }
    }

    public static void writePacketBuffer(PacketBuffer writeTo, PacketBuffer writeFrom) {
        writeTo.func_150787_b(writeFrom.readableBytes());
        writeTo.writeBytes((ByteBuf)writeFrom);
    }

    public static PacketBuffer readPacketBuffer(PacketBuffer buf) {
        ByteBuf directSliceBuffer = buf.readBytes(buf.func_150792_a());
        ByteBuf copiedDataBuffer = Unpooled.copiedBuffer((ByteBuf)directSliceBuffer);
        directSliceBuffer.release();
        return new PacketBuffer(copiedDataBuffer);
    }

    public static void writeFluidStack(PacketBuffer buffer, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            buffer.writeBoolean(true);
        } else {
            buffer.writeBoolean(false);
            NBTTagCompound fluidStackTag = fluidStack.writeToNBT(new NBTTagCompound());
            buffer.func_150786_a(fluidStackTag);
        }
    }

    @Nullable
    public static FluidStack readFluidStack(PacketBuffer buffer) throws IOException {
        if (buffer.readBoolean()) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer.func_150793_b());
    }

    public static void writeStringSafe(PacketBuffer buffer, String string) {
        byte[] bytes;
        byte[] bytesTest = string.getBytes(StandardCharsets.UTF_8);
        if (bytesTest.length > Short.MAX_VALUE) {
            bytes = new byte[Short.MAX_VALUE];
            System.arraycopy(bytesTest, 0, bytes, 0, Short.MAX_VALUE);
            BogoSorter.LOGGER.warn("Warning! Synced string exceeds max length!");
        } else {
            bytes = bytesTest;
        }
        buffer.func_150787_b(bytes.length);
        buffer.writeBytes(bytes);
    }
}

