/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.common.sort.color.ItemColorHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientSortData {
    private final int color;
    private final String name;
    private final int slotNumber;

    @SideOnly(value=Side.CLIENT)
    public static ClientSortData of(Slot slot, boolean getColor, boolean getName) {
        ItemStack itemStack = slot.func_75211_c();
        int color = 0;
        String name = "";
        if (getColor) {
            color = ItemColorHelper.getItemColorHue(itemStack);
        }
        if (getName) {
            name = itemStack.func_82833_r();
        }
        return new ClientSortData(color, name, slot.field_75222_d);
    }

    public static ClientSortData readFromPacket(PacketBuffer buf) {
        int slotNumber = buf.func_150792_a();
        int color = buf.func_150792_a();
        String name = buf.func_150789_c(64);
        return new ClientSortData(color, name, slotNumber);
    }

    public ClientSortData(int color, String name, int slotNumber) {
        this.color = color;
        this.name = name;
        this.slotNumber = slotNumber;
    }

    public int getColor() {
        return this.color;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public String getName() {
        return this.name;
    }

    public void writeToPacket(PacketBuffer buf) {
        buf.func_150787_b(this.slotNumber);
        buf.func_150787_b(this.color);
        buf.func_180714_a(this.name);
    }
}

