/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.api.ISortableContainer;
import com.cleanroommc.bogosorter.api.ISortingContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.Nullable;

public class GuiSortingContext {
    private final Container container;
    private final List<Slot[][]> slots;

    public static GuiSortingContext create(Container container) {
        Builder builder = new Builder(container);
        GuiSortingContext.addPlayerInventory(builder, container);
        if (container instanceof ISortableContainer) {
            ((ISortableContainer)container).buildSortingContext(builder);
        } else {
            BogoSortAPI.INSTANCE.getBuilder(container).accept(container, builder);
        }
        return builder.build();
    }

    public static GuiSortingContext create(Container container, boolean player) {
        if (player) {
            Builder builder = new Builder(container);
            GuiSortingContext.addPlayerInventory(builder, container);
            return builder.build();
        }
        if (container instanceof ISortableContainer) {
            Builder builder = new Builder(container);
            ((ISortableContainer)container).buildSortingContext(builder);
            return builder.build();
        }
        if (BogoSortAPI.isValidSortable(container)) {
            Builder builder = new Builder(container);
            BogoSortAPI.INSTANCE.getBuilder(container).accept(container, builder);
            return builder.build();
        }
        return new GuiSortingContext(container, Collections.emptyList());
    }

    public GuiSortingContext(Container container, List<Slot[][]> slots) {
        this.container = container;
        this.slots = slots;
    }

    @Nullable
    public Slot[][] getSlotGroup(int id) {
        Iterator<Slot[][]> iterator = this.slots.iterator();
        while (iterator.hasNext()) {
            Slot[][] slotGroup;
            Slot[][] slotArray = slotGroup = iterator.next();
            int n = slotArray.length;
            for (int i = 0; i < n; ++i) {
                Slot[] slotRow;
                for (Slot slot : slotRow = slotArray[i]) {
                    if (id != slot.field_75222_d) continue;
                    return slotGroup;
                }
            }
        }
        return null;
    }

    @Nullable
    public Slot[][] getNonPlayerSlotGroup() {
        for (Slot[][] slotGroup : this.slots) {
            if (slotGroup.length == 0 || slotGroup[0].length == 0 || BogoSortAPI.isPlayerSlot(slotGroup[0][0])) continue;
            return slotGroup;
        }
        return null;
    }

    @Nullable
    public Slot[][] getPlayerSlotGroup() {
        for (Slot[][] slotGroup : this.slots) {
            if (slotGroup.length == 0 || slotGroup[0].length == 0 || !BogoSortAPI.isPlayerSlot(slotGroup[0][0])) continue;
            return slotGroup;
        }
        return null;
    }

    public Container getContainer() {
        return this.container;
    }

    private static void addPlayerInventory(Builder builder, Container container) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Slot slot : container.field_75151_b) {
            if (!(slot.field_75224_c instanceof InventoryPlayer) && (!(slot instanceof SlotItemHandler) || !(((SlotItemHandler)slot).getItemHandler() instanceof PlayerMainInvWrapper) && !(((SlotItemHandler)slot).getItemHandler() instanceof PlayerInvWrapper)) || slot.getSlotIndex() < 9 || slot.getSlotIndex() >= 36) continue;
            slots.add(slot);
        }
        if (!slots.isEmpty()) {
            builder.addSlotGroup(9, slots);
        }
    }

    public static class Builder
    implements ISortingContextBuilder {
        private final Container container;
        private final List<Slot[][]> slots = new ArrayList<Slot[][]>();

        public Builder(Container container) {
            this.container = container;
        }

        @Override
        public Builder addSlotGroup(Slot[][] slotGroup) {
            this.slots.add(slotGroup);
            return this;
        }

        @Override
        public Builder addSlotGroup(int rowSize, int startIndex, int endIndex) {
            return this.addSlotGroup(rowSize, this.container.field_75151_b.subList(startIndex, endIndex));
        }

        @Override
        public Builder addSlotGroup(int rowSize, List<Slot> slots) {
            slots = new ArrayList<Slot>(slots);
            slots.sort((slot1, slot2) -> {
                if (slot1.field_75221_f == slot2.field_75221_f) {
                    return Integer.compare(slot1.field_75223_e, slot2.field_75223_e);
                }
                return Integer.compare(slot1.field_75221_f, slot2.field_75221_f);
            });
            int rows = slots.size() / rowSize;
            if (slots.size() % rowSize != 0) {
                ++rows;
            }
            Slot[][] slotGroup = new Slot[rows][rowSize];
            for (int i = 0; i < slots.size(); ++i) {
                slotGroup[i / rowSize][i % rowSize] = slots.get(i);
            }
            if (rows > slots.size() / rowSize) {
                Slot[] lastRow;
                int nulls = 0;
                for (Slot slot : lastRow = slotGroup[rows - 1]) {
                    if (slot != null) continue;
                    ++nulls;
                }
                slotGroup[rows - 1] = Arrays.copyOf(lastRow, lastRow.length - nulls);
            }
            return this.addSlotGroup(slotGroup);
        }

        public GuiSortingContext build() {
            return new GuiSortingContext(this.container, this.slots);
        }
    }
}

