/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.BogoSorter;
import com.cleanroommc.bogosorter.common.OreDictHelper;
import com.cleanroommc.bogosorter.common.sort.ItemSortContainer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import gregtech.api.items.metaitem.FoodUseManager;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IFoodBehavior;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemCompareHelper {
    public static String getMod(ItemStack item) {
        ResourceLocation loc = item.func_77973_b().getRegistryName();
        if (loc == null) {
            throw new IllegalStateException("Item doesn't have a registry name!");
        }
        return loc.func_110624_b();
    }

    public static String getId(ItemStack item) {
        ResourceLocation loc = item.func_77973_b().getRegistryName();
        if (loc == null) {
            throw new IllegalStateException("Item doesn't have a registry name!");
        }
        return loc.func_110623_a();
    }

    public static int getMeta(ItemStack item) {
        return item.func_77960_j();
    }

    public static NBTTagCompound getNbt(ItemStack item) {
        return item.func_77978_p();
    }

    public static float getSaturation(ItemStack item) {
        MetaItem.MetaValueItem valueItem;
        if (item.func_77973_b() instanceof ItemFood) {
            return ((ItemFood)item.func_77973_b()).func_150906_h(item);
        }
        if (BogoSorter.isAnyGtLoaded() && item.func_77973_b() instanceof MetaItem && (valueItem = ((MetaItem)item.func_77973_b()).getItem(item)).getUseManager() instanceof FoodUseManager) {
            IFoodBehavior stats = ((FoodUseManager)valueItem.getUseManager()).getFoodStats();
            return stats.getSaturation(item, null);
        }
        return Float.MIN_VALUE;
    }

    public static int getHunger(ItemStack item) {
        MetaItem.MetaValueItem valueItem;
        if (item.func_77973_b() instanceof ItemFood) {
            return ((ItemFood)item.func_77973_b()).func_150905_g(item);
        }
        if (BogoSorter.isAnyGtLoaded() && item.func_77973_b() instanceof MetaItem && (valueItem = ((MetaItem)item.func_77973_b()).getItem(item)).getUseManager() instanceof FoodUseManager) {
            IFoodBehavior stats = ((FoodUseManager)valueItem.getUseManager()).getFoodStats();
            return stats.getFoodLevel(item, null);
        }
        return Integer.MIN_VALUE;
    }

    public static long getEmcValue(ItemStack item) {
        return EMCHelper.getEmcValue((ItemStack)item);
    }

    public static int compareMod(ItemStack stack1, ItemStack stack2) {
        return ItemCompareHelper.getMod(stack1).compareTo(ItemCompareHelper.getMod(stack2));
    }

    public static int compareId(ItemStack stack1, ItemStack stack2) {
        return ItemCompareHelper.getId(stack1).compareTo(ItemCompareHelper.getId(stack2));
    }

    public static int compareDisplayName(ItemSortContainer stack1, ItemSortContainer stack2) {
        return TextFormatting.func_110646_a((String)stack1.getName()).compareTo(TextFormatting.func_110646_a((String)stack2.getName()));
    }

    public static int compareMeta(ItemStack stack1, ItemStack stack2) {
        return Integer.compare(ItemCompareHelper.getMeta(stack1), ItemCompareHelper.getMeta(stack2));
    }

    public static int compareCount(ItemStack stack1, ItemStack stack2) {
        return Integer.compare(stack2.func_190916_E(), stack1.func_190916_E());
    }

    public static int compareRegistryOrder(ItemStack stack1, ItemStack stack2) {
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.ITEMS;
        return Integer.compare(registry.getID((IForgeRegistryEntry)stack1.func_77973_b()), registry.getID((IForgeRegistryEntry)stack2.func_77973_b()));
    }

    public static int compareOreDict(ItemStack stack1, ItemStack stack2) {
        ArrayList<String> ores1 = new ArrayList<String>(OreDictHelper.getOreDicts(stack1));
        ArrayList<String> ores2 = new ArrayList<String>(OreDictHelper.getOreDicts(stack2));
        if (ores1.isEmpty() && ores2.isEmpty()) {
            return 0;
        }
        if (ores1.size() != ores2.size()) {
            return Integer.compare(ores1.size(), ores2.size());
        }
        if (ores1.size() > 1) {
            ores1.sort(String::compareTo);
            ores2.sort(String::compareTo);
        }
        int val = 0;
        int n = ores1.size();
        for (int i = 0; i < n; ++i) {
            val += ((String)ores1.get(i)).compareTo((String)ores2.get(i));
        }
        return MathHelper.func_76125_a((int)val, (int)-1, (int)1);
    }

    public static int compareHasNbt(ItemStack stack1, ItemStack stack2) {
        NBTTagCompound nbt2;
        NBTTagCompound nbt1 = stack1.func_77978_p();
        if (nbt1 == null == ((nbt2 = stack2.func_77978_p()) == null)) {
            return 0;
        }
        if (nbt1 == null) {
            return -1;
        }
        return 1;
    }

    public static int compareNotNullNbt(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int result = ItemCompareHelper.compareNbtSize(nbt1, nbt2);
        if (result != 0) {
            return result;
        }
        return ItemCompareHelper.compareNbtValues(nbt1, nbt2);
    }

    public static int compareNbtValues(ItemStack itemStack1, ItemStack itemStack2) {
        int result = ItemCompareHelper.compareHasNbt(itemStack1, itemStack2);
        if (result != 0) {
            return result;
        }
        return itemStack1.func_77942_o() ? ItemCompareHelper.compareNbtValues(itemStack1.func_77978_p(), itemStack2.func_77978_p()) : 0;
    }

    public static int compareNbtValues(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int result = 0;
        for (NbtSortRule nbtSortRule : SortHandler.currentNbtSortRules.get()) {
            result = nbtSortRule.compare(nbt1, nbt2);
            if (result == 0) continue;
            return result;
        }
        return result;
    }

    public static int compareNbtAllValues(ItemStack itemStack1, ItemStack itemStack2) {
        int result = ItemCompareHelper.compareHasNbt(itemStack1, itemStack2);
        if (result != 0) {
            return result;
        }
        return itemStack1.func_77942_o() ? ItemCompareHelper.compareNbtAllValues(itemStack1.func_77978_p(), itemStack2.func_77978_p()) : 0;
    }

    public static int compareNbtAllValues(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int total = 0;
        for (String key : nbt1.func_150296_c()) {
            if (!nbt2.func_74764_b(key)) continue;
            int result = ItemCompareHelper.compareNbtBase(nbt1.func_74781_a(key), nbt2.func_74781_a(key));
            total += result;
        }
        return MathHelper.func_76125_a((int)total, (int)-1, (int)1);
    }

    public static int compareNbtBase(NBTBase nbt1, NBTBase nbt2) {
        if (nbt1.func_74732_a() != nbt2.func_74732_a()) {
            return 0;
        }
        if (nbt1.func_74732_a() == 10) {
            return ItemCompareHelper.compareNbtAllValues((NBTTagCompound)nbt1, (NBTTagCompound)nbt2);
        }
        if (nbt1 instanceof NBTPrimitive) {
            return Double.compare(((NBTPrimitive)nbt1).func_150286_g(), ((NBTPrimitive)nbt2).func_150286_g());
        }
        if (nbt1.func_74732_a() == 7) {
            byte[] array2;
            byte[] array1 = ((NBTTagByteArray)nbt1).func_150292_c();
            if (array1.length != (array2 = ((NBTTagByteArray)nbt2).func_150292_c()).length) {
                return array1.length < array2.length ? -1 : 1;
            }
            int total = 0;
            for (int i = 0; i < array1.length; ++i) {
                total += Byte.compare(array1[i], array2[i]);
            }
            return total;
        }
        if (nbt1.func_74732_a() == 11) {
            int[] array2;
            int[] array1 = ((NBTTagIntArray)nbt1).func_150302_c();
            if (array1.length != (array2 = ((NBTTagIntArray)nbt2).func_150302_c()).length) {
                return array1.length < array2.length ? -1 : 1;
            }
            int total = 0;
            for (int i = 0; i < array1.length; ++i) {
                total += Integer.compare(array1[i], array2[i]);
            }
            return total;
        }
        if (nbt1.func_74732_a() == 12) {
            return 0;
        }
        return 0;
    }

    public static int compareNbtSize(ItemStack itemStack1, ItemStack itemStack2) {
        int result = ItemCompareHelper.compareHasNbt(itemStack1, itemStack2);
        if (result != 0) {
            return result;
        }
        return itemStack1.func_77942_o() ? ItemCompareHelper.compareNbtSize(itemStack1.func_77978_p(), itemStack2.func_77978_p()) : 0;
    }

    public static int compareNbtSize(@NotNull NBTTagCompound nbt1, @NotNull NBTTagCompound nbt2) {
        int size2;
        int size1;
        if (nbt1.func_186856_d() < nbt2.func_186856_d()) {
            return -1;
        }
        if (nbt1.func_186856_d() > nbt2.func_186856_d()) {
            return 1;
        }
        List<NBTTagCompound> subTags1 = new ArrayList<NBTTagCompound>();
        List<NBTTagCompound> subTags2 = new ArrayList<NBTTagCompound>();
        subTags1.add(nbt1);
        subTags2.add(nbt2);
        do {
            subTags1 = ItemCompareHelper.getAllSubTags(subTags1);
            subTags2 = ItemCompareHelper.getAllSubTags(subTags2);
            size1 = ItemCompareHelper.getTotalSubTags(subTags1);
            size2 = ItemCompareHelper.getTotalSubTags(subTags2);
            if (size1 == 0 && size2 == 0) {
                return 0;
            }
            if (size1 >= size2) continue;
            return -1;
        } while (size1 <= size2);
        return 1;
    }

    @Nullable
    public static NBTBase findSubTag(String path, NBTBase tag) {
        String[] parts;
        if (tag == null || path == null || path.isEmpty()) {
            return null;
        }
        for (String part : parts = path.split("/")) {
            if (tag == null || tag.func_74732_a() != 10) {
                return null;
            }
            tag = ((NBTTagCompound)tag).func_74781_a(part);
        }
        return tag;
    }

    private static List<NBTTagCompound> getAllSubTags(List<NBTTagCompound> tags) {
        ArrayList<NBTTagCompound> subTags = new ArrayList<NBTTagCompound>();
        for (NBTTagCompound nbt : tags) {
            for (String key : nbt.func_150296_c()) {
                NBTBase nbtBase = nbt.func_74781_a(key);
                if (!(nbt.func_74781_a(key) instanceof NBTTagCompound)) continue;
                subTags.add((NBTTagCompound)nbtBase);
            }
        }
        return subTags;
    }

    private static int getTotalSubTags(List<NBTTagCompound> tags) {
        int sum = 0;
        for (NBTTagCompound nbt : tags) {
            sum += nbt.func_186856_d();
        }
        return sum;
    }

    public static int comparePotionId(String potion1, String potion2) {
        String id2;
        String id1 = potion1.startsWith("strong") || potion1.startsWith("long") ? potion1.substring(potion1.indexOf(95) + 1) : potion1;
        int result = id1.compareTo(id2 = potion2.startsWith("strong") || potion2.startsWith("long") ? potion2.substring(potion2.indexOf(95) + 1) : potion2);
        if (result != 0) {
            return result;
        }
        boolean strong1 = potion1.startsWith("strong");
        boolean strong2 = potion2.startsWith("strong");
        if (strong1 && !strong2) {
            return 1;
        }
        if (!strong1 && strong2) {
            return -1;
        }
        return Boolean.compare(potion1.startsWith("long"), potion2.startsWith("long"));
    }

    public static int compareEnchantments(NBTTagList enchantments1, NBTTagList enchantments2) {
        NBTTagCompound nbt;
        int total1 = 0;
        for (Object nbtBase : enchantments1) {
            NBTTagCompound nbt2 = (NBTTagCompound)nbtBase;
            total1 += nbt2.func_74765_d("id");
        }
        int total2 = 0;
        for (NBTBase nbtBase : enchantments2) {
            NBTTagCompound nbt3 = (NBTTagCompound)nbtBase;
            total2 += nbt3.func_74765_d("id");
        }
        int result = Integer.compare(total1, total2);
        if (result != 0) {
            return result;
        }
        total1 = 0;
        for (NBTBase nbtBase : enchantments1) {
            nbt = (NBTTagCompound)nbtBase;
            total1 += nbt.func_74765_d("lvl");
        }
        total2 = 0;
        for (NBTBase nbtBase : enchantments2) {
            nbt = (NBTTagCompound)nbtBase;
            total2 += nbt.func_74765_d("lvl");
        }
        return Integer.compare(total1, total2);
    }

    public static int compareEnchantment(NBTTagCompound enchantment1, NBTTagCompound enchantment2) {
        int result = Integer.compare(enchantment1.func_74765_d("id"), enchantment2.func_74765_d("id"));
        if (result != 0) {
            return result;
        }
        return Integer.compare(enchantment1.func_74765_d("lvl"), enchantment2.func_74765_d("lvl"));
    }

    public static int compareMaterial(ItemStack item1, ItemStack item2) {
        String mat1 = OreDictHelper.getMaterial(item1);
        String mat2 = OreDictHelper.getMaterial(item2);
        if (mat1 == null && mat2 == null) {
            return 0;
        }
        if (mat1 == null) {
            return 1;
        }
        return mat2 == null ? -1 : mat1.compareTo(mat2);
    }

    public static int compareOrePrefix(ItemStack item1, ItemStack item2) {
        String prefix = OreDictHelper.getOrePrefix(item1);
        String prefix1 = OreDictHelper.getOrePrefix(item2);
        if (prefix == null && prefix1 == null) {
            return 0;
        }
        if (prefix == null) {
            return 1;
        }
        if (prefix1 == null) {
            return -1;
        }
        return Integer.compare(OreDictHelper.getOrePrefixIndex(prefix), OreDictHelper.getOrePrefixIndex(prefix1));
    }

    public static int compareEMC(ItemStack item1, ItemStack item2) {
        return Long.compare(ItemCompareHelper.getEmcValue(item2), ItemCompareHelper.getEmcValue(item1));
    }

    public static int compareIsBlock(ItemStack item1, ItemStack item2) {
        return Boolean.compare(item2.func_77973_b() instanceof ItemBlock, item1.func_77973_b() instanceof ItemBlock);
    }

    public static int compareBurnTime(ItemStack item1, ItemStack item2) {
        return Integer.compare(item2.func_77973_b().getItemBurnTime(item2), item1.func_77973_b().getItemBurnTime(item1));
    }

    public static int compareSaturation(ItemStack item1, ItemStack item2) {
        return Float.compare(ItemCompareHelper.getSaturation(item2), ItemCompareHelper.getSaturation(item1));
    }

    public static int compareHunger(ItemStack item1, ItemStack item2) {
        return Integer.compare(ItemCompareHelper.getHunger(item2), ItemCompareHelper.getHunger(item1));
    }

    public static int compareColor(ItemSortContainer item1, ItemSortContainer item2) {
        return Integer.compare(item1.getColorHue(), item2.getColorHue());
    }
}

