/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public class ItemSortContainer {
    private final ItemStack itemStack;
    private final ClientSortData sortData;
    private int amount;

    public ItemSortContainer(ItemStack itemStack, ClientSortData sortData) {
        this.itemStack = itemStack;
        this.sortData = sortData;
        this.amount = 0;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ClientSortData getSortData() {
        return this.sortData;
    }

    public int getColorHue() {
        return this.sortData.getColor();
    }

    public String getName() {
        return this.sortData.getName();
    }

    public void shrink(int amount) {
        this.amount -= amount;
    }

    public void grow(int amount) {
        this.amount += amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean canMakeStack() {
        return this.amount > 0;
    }

    public ItemStack makeStack(int max) {
        ItemStack copy = this.itemStack.func_77946_l();
        int size = Math.min(max, Math.min(copy.func_77976_d(), this.amount));
        copy.func_190920_e(size);
        this.shrink(size);
        return copy;
    }

    public int hashCode() {
        ItemStack o = this.itemStack;
        return Objects.hash(o.func_77973_b(), o.func_77960_j(), o.func_77978_p(), BogoSortAPI.getItemAccessor(o).getCapNBT());
    }

    public boolean equals(Object b1) {
        ItemStack b;
        ItemStack a = this.itemStack;
        if (a == b1) {
            return true;
        }
        if (a == null || b1 == null) {
            return false;
        }
        if (b1 instanceof ItemStack) {
            b = (ItemStack)b1;
        } else if (b1 instanceof ItemSortContainer) {
            b = ((ItemSortContainer)b1).itemStack;
        } else {
            return false;
        }
        return a.func_190926_b() && b.func_190926_b() || a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && Objects.equals(a.func_77978_p(), b.func_77978_p()) && Objects.equals(BogoSortAPI.getItemAccessor(a).getCapNBT(), BogoSortAPI.getItemAccessor(b).getCapNBT());
    }
}

