/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.api.SortType;
import com.cleanroommc.bogosorter.common.sort.ItemCompareHelper;
import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;

public class NbtSortRule
extends SortRule<NBTBase> {
    private final String tagPath;

    public NbtSortRule(String key, String tagPath, Comparator<NBTBase> comparator) {
        super(key, SortType.NBT, NbtSortRule.createComparator(tagPath, comparator));
        this.tagPath = tagPath;
    }

    public NbtSortRule(String key, String tagPath, int expectedType) {
        this(key, tagPath, NbtSortRule.createComparator(expectedType, ItemCompareHelper::compareNbtBase, nbtBase -> nbtBase));
    }

    public <T> NbtSortRule(String key, String tagPath, int expectedType, Comparator<T> comparator, Function<NBTBase, T> converter) {
        this(key, tagPath, NbtSortRule.createComparator(expectedType, comparator, converter));
    }

    private static Comparator<NBTBase> createComparator(String path, Comparator<NBTBase> comparator) {
        return (o1, o2) -> {
            if (o1 == null || o2 == null) {
                return 0;
            }
            NBTBase nbt1 = ItemCompareHelper.findSubTag(path, o1);
            NBTBase nbt2 = ItemCompareHelper.findSubTag(path, o2);
            return comparator.compare(nbt1, nbt2);
        };
    }

    private static <T> Comparator<NBTBase> createComparator(int expectedType, Comparator<T> comparator, Function<NBTBase, T> converter) {
        return (o1, o2) -> {
            Object t2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.func_74732_a() != expectedType && o2.func_74732_a() != expectedType) {
                return 0;
            }
            if (o1.func_74732_a() != expectedType) {
                return -1;
            }
            if (o2.func_74732_a() != expectedType) {
                return 1;
            }
            Object t1 = converter.apply((NBTBase)o1);
            if (t1 == (t2 = converter.apply((NBTBase)o2))) {
                return 0;
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return comparator.compare(t1, t2);
        };
    }

    @Override
    public String getNameLangKey() {
        return "bogosort.sortrules.nbt." + this.getKey() + ".name";
    }

    @Override
    public String getDescriptionLangKey() {
        return "bogosort.sortrules.nbt." + this.getKey() + ".description";
    }
}

