/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.ClientEventHandler;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.McUtils;
import com.cleanroommc.bogosorter.common.config.BogoSorterConfig;
import com.cleanroommc.bogosorter.common.network.CSlotSync;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.ClientItemSortRule;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.ItemCompareHelper;
import com.cleanroommc.bogosorter.common.sort.ItemSortContainer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class SortHandler {
    public static final Map<EntityPlayer, List<SortRule<ItemStack>>> cacheItemSortRules = new Object2ObjectOpenHashMap();
    public static final Map<EntityPlayer, List<NbtSortRule>> cacheNbtSortRules = new Object2ObjectOpenHashMap();
    public static final AtomicReference<List<NbtSortRule>> currentNbtSortRules = new AtomicReference(Collections.emptyList());
    private final EntityPlayer player;
    private final Container container;
    private final GuiSortingContext context;
    private final Comparator<ItemSortContainer> containerComparator;
    private final Int2ObjectMap<ClientSortData> clientSortData;
    private final List<SortRule<ItemStack>> itemSortRules;

    public SortHandler(EntityPlayer entityPlayer, Container container, boolean player, Int2ObjectMap<ClientSortData> clientSortData) {
        this(entityPlayer, container, GuiSortingContext.create(container, player), clientSortData);
    }

    public SortHandler(EntityPlayer player, Container container, GuiSortingContext sortingContext, Int2ObjectMap<ClientSortData> clientSortData) {
        this.player = player;
        this.container = container;
        this.context = sortingContext;
        this.itemSortRules = cacheItemSortRules.getOrDefault(player, Collections.emptyList());
        this.containerComparator = (container1, container2) -> {
            int result;
            for (SortRule<ItemStack> sortRule : this.itemSortRules) {
                result = sortRule instanceof ClientItemSortRule ? ((ClientItemSortRule)sortRule).compareClient((ItemSortContainer)container1, (ItemSortContainer)container2) : sortRule.compare(container1.getItemStack(), container2.getItemStack());
                if (result == 0) continue;
                return result;
            }
            result = ItemCompareHelper.compareRegistryOrder(container1.getItemStack(), container2.getItemStack());
            if (result != 0) {
                return result;
            }
            result = ItemCompareHelper.compareMeta(container1.getItemStack(), container2.getItemStack());
            return result;
        };
        this.clientSortData = clientSortData;
    }

    public void sort(int slotId) {
        this.sort(slotId, true);
    }

    public void sort(int slotId, boolean sync) {
        Slot[][] slotGroup = this.context.getSlotGroup(slotId);
        this.sort(slotGroup, sync);
    }

    public void sort(Slot[][] slotGroup, boolean sync) {
        if (slotGroup != null) {
            Random random = new Random();
            if (random.nextFloat() < 5.0E-4f) {
                SortHandler.sortBogo(slotGroup);
                this.player.func_145747_a((ITextComponent)new TextComponentString("Get Bogo'd!"));
            } else {
                this.sortHorizontal(slotGroup);
            }
            if (sync) {
                this.container.func_75142_b();
            }
        }
    }

    public void sortHorizontal(Slot[][] slotGroup) {
        LinkedList<ItemSortContainer> itemList = this.gatherItems(slotGroup);
        if (itemList.isEmpty()) {
            return;
        }
        currentNbtSortRules.set(cacheNbtSortRules.getOrDefault(this.player, Collections.emptyList()));
        itemList.sort(this.containerComparator);
        currentNbtSortRules.set(Collections.emptyList());
        ItemSortContainer itemSortContainer = itemList.pollFirst();
        if (itemSortContainer == null) {
            return;
        }
        Slot[][] slotArray = slotGroup;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] slotRow;
            for (Slot slot : slotRow = slotArray[i]) {
                if (itemSortContainer == null) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                    continue;
                }
                int max = slot.func_178170_b(itemSortContainer.getItemStack());
                if (max <= 0) continue;
                slot.func_75215_d(itemSortContainer.makeStack(max));
                if (itemSortContainer.canMakeStack()) continue;
                itemSortContainer = itemList.pollFirst();
            }
        }
        if (!itemList.isEmpty()) {
            McUtils.giveItemsToPlayer(this.player, SortHandler.prepareDropList(itemList));
        }
    }

    public void sortVertical(Slot[][] slotGroup) {
        LinkedList<ItemSortContainer> itemList = this.gatherItems(slotGroup);
        if (itemList.isEmpty()) {
            return;
        }
        currentNbtSortRules.set(cacheNbtSortRules.getOrDefault(this.player, Collections.emptyList()));
        itemList.sort(this.containerComparator);
        currentNbtSortRules.set(Collections.emptyList());
        ItemSortContainer itemSortContainer = itemList.pollFirst();
        if (itemSortContainer == null) {
            return;
        }
        block0: for (int c = 0; c < slotGroup[0].length; ++c) {
            for (Slot[] slots : slotGroup) {
                int max;
                if (c >= slots.length) break block0;
                Slot slot = slots[c];
                if (itemSortContainer == null) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                    continue;
                }
                if (!itemSortContainer.canMakeStack() && (itemSortContainer = itemList.pollFirst()) == null || (max = slot.func_178170_b(itemSortContainer.getItemStack())) <= 0) continue;
                slot.func_75215_d(itemSortContainer.makeStack(max));
            }
        }
        if (!itemList.isEmpty()) {
            McUtils.giveItemsToPlayer(this.player, SortHandler.prepareDropList(itemList));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void sortBogo(Slot[][] slotGroup) {
        void var5_10;
        ItemStack[][] itemGrid;
        for (Object[] objectArray : itemGrid = new ItemStack[slotGroup.length][slotGroup[0].length]) {
            Arrays.fill(objectArray, ItemStack.field_190927_a);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Slot[][] slotArray = slotGroup;
        int n = slotArray.length;
        boolean bl = false;
        while (var5_10 < n) {
            Slot[] slotRow;
            for (Slot slot : slotRow = slotArray[var5_10]) {
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                items.add(stack);
            }
            ++var5_10;
        }
        Random rnd = new Random();
        for (ItemStack itemStack : items) {
            int slot;
            int row;
            while (!itemGrid[row = rnd.nextInt(itemGrid.length)][slot = rnd.nextInt(itemGrid[row].length)].func_190926_b()) {
            }
            itemGrid[row][slot] = itemStack;
        }
        for (int r = 0; r < slotGroup.length; ++r) {
            void var5_13;
            boolean bl2 = false;
            while (var5_13 < slotGroup[r].length) {
                slotGroup[r][var5_13].func_75215_d(itemGrid[r][var5_13]);
                ++var5_13;
            }
        }
    }

    public LinkedList<ItemSortContainer> gatherItems(Slot[][] slotGroup) {
        LinkedList<ItemSortContainer> list = new LinkedList<ItemSortContainer>();
        Object2ObjectOpenCustomHashMap items = new Object2ObjectOpenCustomHashMap(BogoSortAPI.ITEM_META_NBT_HASH_STRATEGY);
        Slot[][] slotArray = slotGroup;
        int n = slotArray.length;
        for (int i = 0; i < n; ++i) {
            Slot[] slotRow;
            for (Slot slot : slotRow = slotArray[i]) {
                ItemStack stack = slot.func_75211_c();
                if (stack.func_190926_b()) continue;
                ItemSortContainer container1 = (ItemSortContainer)items.get((Object)stack);
                if (container1 == null) {
                    container1 = new ItemSortContainer(stack, (ClientSortData)this.clientSortData.get(slot.field_75222_d));
                    items.put((Object)stack, (Object)container1);
                    list.add(container1);
                }
                container1.grow(stack.func_190916_E());
            }
        }
        return list;
    }

    private static List<ItemStack> prepareDropList(List<ItemSortContainer> sortedList) {
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        for (ItemSortContainer itemSortContainer : sortedList) {
            while (itemSortContainer.canMakeStack()) {
                dropList.add(itemSortContainer.makeStack(Integer.MAX_VALUE));
            }
        }
        return dropList;
    }

    @SideOnly(value=Side.CLIENT)
    public static Comparator<ItemStack> getClientItemComparator() {
        return (stack1, stack2) -> {
            int result = 0;
            for (SortRule<ItemStack> sortRule : BogoSorterConfig.sortRules) {
                result = sortRule.compare((ItemStack)stack1, (ItemStack)stack2);
                if (result == 0) continue;
                return result;
            }
            result = ItemCompareHelper.compareRegistryOrder(stack1, stack2);
            if (result != 0) {
                return result;
            }
            result = ItemCompareHelper.compareMeta(stack1, stack2);
            return result;
        };
    }

    public void clearAllItems(Slot slot1) {
        Slot[][] slotGroup = this.context.getSlotGroup(slot1.field_75222_d);
        if (slotGroup != null) {
            ArrayList<Pair<ItemStack, Integer>> slots = new ArrayList<Pair<ItemStack, Integer>>();
            Slot[][] slotArray = slotGroup;
            int n = slotArray.length;
            for (int i = 0; i < n; ++i) {
                Slot[] slotRow;
                for (Slot slot : slotRow = slotArray[i]) {
                    if (slot.func_75211_c().func_190926_b()) continue;
                    slot.func_75215_d(ItemStack.field_190927_a);
                    slots.add((Pair<ItemStack, Integer>)Pair.of((Object)ItemStack.field_190927_a, (Object)slot.field_75222_d));
                }
            }
            NetworkHandler.sendToServer(new CSlotSync(slots));
        }
    }

    public void randomizeItems(Slot slot1) {
        Slot[][] slotGroup = this.context.getSlotGroup(slot1.field_75222_d);
        if (slotGroup != null) {
            ArrayList<Pair<ItemStack, Integer>> slots = new ArrayList<Pair<ItemStack, Integer>>();
            Random random = new Random();
            Slot[][] slotArray = slotGroup;
            int n = slotArray.length;
            for (int i = 0; i < n; ++i) {
                Slot[] slotRow;
                for (Slot slot : slotRow = slotArray[i]) {
                    if (!(random.nextFloat() < 0.3f)) continue;
                    ItemStack randomItem = ClientEventHandler.allItems.get(random.nextInt(ClientEventHandler.allItems.size())).func_77946_l();
                    slot.func_75215_d(randomItem.func_77946_l());
                    slots.add((Pair<ItemStack, Integer>)Pair.of((Object)randomItem, (Object)slot.field_75222_d));
                }
            }
            NetworkHandler.sendToServer(new CSlotSync(slots));
        }
    }
}

