/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.sort.color;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.BogoSorter;
import com.cleanroommc.bogosorter.common.sort.color.ColorThief;
import com.cleanroommc.modularui.utils.Color;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.GTUtility;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.awt.image.BufferedImage;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ItemColorHelper {
    private static final Object2IntMap<ItemStack> ITEM_COLORS = new Object2IntOpenCustomHashMap(BogoSortAPI.ITEM_META_NBT_HASH_STRATEGY);

    public static int getHue(int color) {
        float hue;
        if (color == 0) {
            return 0;
        }
        float r = Color.getRedF((int)color);
        float g = Color.getGreenF((int)color);
        float b = Color.getBlueF((int)color);
        float min = Math.min(r, Math.min(g, b));
        if (r > g && r > b) {
            hue = (g - b) / (r - min);
        } else if (g > r && g > b) {
            hue = 2.0f + (b - r) / (g - min);
        } else if (b > r && b > g) {
            hue = 4.0f + (r - g) / (b - min);
        } else {
            return 0;
        }
        hue *= 60.0f;
        if (hue < 0.0f) {
            hue += 360.0f;
        }
        return (int)hue;
    }

    public static int getItemColorHue(ItemStack item) {
        return ItemColorHelper.getHue(ItemColorHelper.getAverageItemColor(item));
    }

    public static int getAverageItemColor(ItemStack item) {
        if (item.func_190926_b()) {
            return 0;
        }
        if (ITEM_COLORS.containsKey((Object)item)) {
            return ITEM_COLORS.getInt((Object)item);
        }
        int color = item.func_77973_b() instanceof ItemBlock ? ItemColorHelper.getBlockColors(item, ((ItemBlock)item.func_77973_b()).func_179223_d()) : ItemColorHelper.getItemColors(item);
        ITEM_COLORS.put((Object)item, color);
        return color;
    }

    private static int getItemColors(ItemStack itemStack) {
        try {
            ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
            int renderColor = itemColors.func_186728_a(itemStack, 0);
            TextureAtlasSprite textureAtlasSprite = ItemColorHelper.getTextureAtlasSprite(itemStack);
            return ItemColorHelper.getColors(textureAtlasSprite, renderColor);
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private static int getBlockColors(ItemStack itemStack, Block block) {
        TextureAtlasSprite textureAtlasSprite;
        IBlockState blockState;
        int meta = itemStack.func_77960_j();
        try {
            blockState = block.func_176203_a(meta);
        }
        catch (LinkageError | RuntimeException ignored) {
            blockState = block.func_176223_P();
        }
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int renderColor = blockColors.func_186724_a(blockState, null, null, 0);
        if (BogoSorter.isGTCEuLoaded() && blockState.func_177230_c() instanceof BlockMachine) {
            MetaTileEntity mte = GTUtility.getMetaTileEntity((ItemStack)itemStack);
            Pair pair = mte.getParticleTexture();
            textureAtlasSprite = (TextureAtlasSprite)pair.getKey();
            renderColor = (Integer)pair.getRight();
        } else {
            textureAtlasSprite = ItemColorHelper.getTextureAtlasSprite(blockState);
        }
        return ItemColorHelper.getColors(textureAtlasSprite, renderColor);
    }

    public static int getColors(TextureAtlasSprite textureAtlasSprite, int renderColor) {
        BufferedImage bufferedImage;
        int[] color = textureAtlasSprite == null ? new int[]{0, 0, 0} : ((bufferedImage = ItemColorHelper.getBufferedImage(textureAtlasSprite)) == null ? new int[]{0, 0, 0} : ColorThief.getColor(bufferedImage, 10, true));
        if (color == null) {
            return 0;
        }
        int red = (int)((float)(color[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
        int green = (int)((float)(color[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
        int blue = (int)((float)(color[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
        red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        return Color.rgb((int)red, (int)green, (int)blue);
    }

    @Nullable
    private static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(IBlockState blockState) {
        Minecraft minecraft = Minecraft.func_71410_x();
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        BlockModelShapes blockModelShapes = blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(blockState);
        if (textureAtlasSprite == minecraft.func_147117_R().func_174944_f()) {
            return null;
        }
        return textureAtlasSprite;
    }

    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ItemModelMesher itemModelMesher = renderItem.func_175037_a();
        IBakedModel itemModel = itemModelMesher.func_178089_a(itemStack);
        return itemModel.func_177554_e();
    }
}

