/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import me.lucko.spark.common.sampler.async.AsyncStackTraceElement;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.StackTraceNode;

public abstract class AbstractNode {
    private static final int MAX_STACK_DEPTH = 300;
    private final Map<StackTraceNode.Description, StackTraceNode> children = new ConcurrentHashMap<StackTraceNode.Description, StackTraceNode>();
    private final LongAdder totalTime = new LongAdder();

    public double getTotalTime() {
        return (double)this.totalTime.longValue() / 1000.0;
    }

    public void merge(AbstractNode other) {
        this.totalTime.add(other.totalTime.longValue());
        for (Map.Entry<StackTraceNode.Description, StackTraceNode> child : other.children.entrySet()) {
            this.resolveChild(child.getKey()).merge(child.getValue());
        }
    }

    private AbstractNode resolveChild(StackTraceNode.Description description) {
        StackTraceNode result = this.children.get(description);
        if (result != null) {
            return result;
        }
        return this.children.computeIfAbsent(description, name -> new StackTraceNode(description));
    }

    public void log(StackTraceElement[] elements, long time) {
        this.log(elements, 0, time);
    }

    private void log(StackTraceElement[] elements, int offset, long time) {
        this.totalTime.add(time);
        if (offset >= 300) {
            return;
        }
        if (elements.length - offset == 0) {
            return;
        }
        int pointer = elements.length - 1 - offset;
        StackTraceElement element = elements[pointer];
        StackTraceElement parent = offset == 0 ? null : elements[pointer + 1];
        int parentLineNumber = parent == null ? -1 : parent.getLineNumber();
        AbstractNode child = this.resolveChild(new StackTraceNode.Description(element.getClassName(), element.getMethodName(), element.getLineNumber(), parentLineNumber));
        child.log(elements, offset + 1, time);
    }

    public void log(AsyncStackTraceElement[] elements, long time) {
        this.log(elements, 0, time);
    }

    private void log(AsyncStackTraceElement[] elements, int offset, long time) {
        this.totalTime.add(time);
        if (offset >= 300) {
            return;
        }
        if (elements.length - offset == 0) {
            return;
        }
        int pointer = elements.length - 1 - offset;
        AsyncStackTraceElement element = elements[pointer];
        AbstractNode child = this.resolveChild(new StackTraceNode.Description(element.getClassName(), element.getMethodName(), element.getMethodDescription()));
        child.log(elements, offset + 1, time);
    }

    protected List<StackTraceNode> exportChildren(MergeMode mergeMode) {
        if (this.children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StackTraceNode> list = new ArrayList<StackTraceNode>(this.children.size());
        block0: for (StackTraceNode child : this.children.values()) {
            for (StackTraceNode other : list) {
                if (!mergeMode.shouldMerge(other, child)) continue;
                other.merge(child);
                continue block0;
            }
            list.add(child);
        }
        list.sort(null);
        return list;
    }
}

