/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import me.lucko.spark.common.util.AbstractHttpClient;
import me.lucko.spark.lib.okhttp3.MediaType;
import me.lucko.spark.lib.okhttp3.OkHttpClient;
import me.lucko.spark.lib.okhttp3.Request;
import me.lucko.spark.lib.okhttp3.RequestBody;
import me.lucko.spark.lib.okhttp3.Response;

public class BytebinClient
extends AbstractHttpClient {
    private final String url;
    private final String userAgent;

    public BytebinClient(OkHttpClient okHttpClient, String url, String userAgent) {
        super(okHttpClient);
        this.url = url.endsWith("/") ? url : url + "/";
        this.userAgent = userAgent;
    }

    public Content postContent(byte[] buf, MediaType contentType, boolean allowModification) throws IOException {
        RequestBody body = RequestBody.create(contentType, buf);
        Request.Builder requestBuilder = new Request.Builder().url(this.url + "post").header("User-Agent", this.userAgent).header("Content-Encoding", "gzip");
        if (allowModification) {
            requestBuilder.header("Allow-Modification", "true");
        }
        Request request = requestBuilder.post(body).build();
        try (Response response = this.makeHttpRequest(request);){
            String key = response.header("Location");
            if (key == null) {
                throw new IllegalStateException("Key not returned");
            }
            if (allowModification) {
                String modificationKey = response.header("Modification-Key");
                if (modificationKey == null) {
                    throw new IllegalStateException("Modification key not returned");
                }
                Content content = new Content(key, modificationKey);
                return content;
            }
            Content content = new Content(key);
            return content;
        }
    }

    public void modifyContent(Content existingContent, byte[] buf, MediaType contentType) throws IOException {
        if (!existingContent.modifiable) {
            throw new IllegalArgumentException("Existing content is not modifiable");
        }
        RequestBody body = RequestBody.create(contentType, buf);
        Request.Builder requestBuilder = new Request.Builder().url(this.url + existingContent.key()).header("User-Agent", this.userAgent).header("Content-Encoding", "gzip").header("Modification-Key", existingContent.modificationKey);
        Request request = requestBuilder.put(body).build();
        this.makeHttpRequest(request).close();
    }

    public static final class Content {
        private final String key;
        private final boolean modifiable;
        private final String modificationKey;

        Content(String key) {
            this.key = key;
            this.modifiable = false;
            this.modificationKey = null;
        }

        Content(String key, String modificationKey) {
            this.key = key;
            this.modifiable = true;
            this.modificationKey = modificationKey;
        }

        public String key() {
            return this.key;
        }
    }
}

