/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.adventure.text.event;

import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import me.lucko.spark.lib.adventure.examination.Examinable;
import me.lucko.spark.lib.adventure.examination.ExaminableProperty;
import me.lucko.spark.lib.adventure.examination.string.StringExaminer;
import me.lucko.spark.lib.adventure.key.Key;
import me.lucko.spark.lib.adventure.key.Keyed;
import me.lucko.spark.lib.adventure.nbt.api.BinaryTagHolder;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.ComponentLike;
import me.lucko.spark.lib.adventure.text.event.HoverEventSource;
import me.lucko.spark.lib.adventure.text.format.StyleBuilderApplicable;
import me.lucko.spark.lib.adventure.text.renderer.ComponentRenderer;
import me.lucko.spark.lib.adventure.util.Index;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HoverEvent<V>
implements Examinable,
HoverEventSource<V>,
StyleBuilderApplicable {
    private final Action<V> action;
    private final V value;

    public static @NonNull HoverEvent<Component> showText(@NonNull ComponentLike text) {
        return HoverEvent.showText(text.asComponent());
    }

    public static @NonNull HoverEvent<Component> showText(@NonNull Component text) {
        return new HoverEvent<Component>(Action.SHOW_TEXT, text);
    }

    public static @NonNull HoverEvent<ShowItem> showItem(@NonNull Key item, @NonNegative int count) {
        return HoverEvent.showItem(item, count, null);
    }

    public static @NonNull HoverEvent<ShowItem> showItem(@NonNull Keyed item, @NonNegative int count) {
        return HoverEvent.showItem(item, count, null);
    }

    public static @NonNull HoverEvent<ShowItem> showItem(@NonNull Key item, @NonNegative int count, @Nullable BinaryTagHolder nbt) {
        return HoverEvent.showItem(ShowItem.of(item, count, nbt));
    }

    public static @NonNull HoverEvent<ShowItem> showItem(@NonNull Keyed item, @NonNegative int count, @Nullable BinaryTagHolder nbt) {
        return HoverEvent.showItem(ShowItem.of(item, count, nbt));
    }

    public static @NonNull HoverEvent<ShowItem> showItem(@NonNull ShowItem item) {
        return new HoverEvent<ShowItem>(Action.SHOW_ITEM, item);
    }

    public static @NonNull HoverEvent<ShowEntity> showEntity(@NonNull Key type, @NonNull UUID id) {
        return HoverEvent.showEntity(type, id, null);
    }

    public static @NonNull HoverEvent<ShowEntity> showEntity(@NonNull Keyed type, @NonNull UUID id) {
        return HoverEvent.showEntity(type, id, null);
    }

    public static @NonNull HoverEvent<ShowEntity> showEntity(@NonNull Key type, @NonNull UUID id, @Nullable Component name) {
        return HoverEvent.showEntity(ShowEntity.of(type, id, name));
    }

    public static @NonNull HoverEvent<ShowEntity> showEntity(@NonNull Keyed type, @NonNull UUID id, @Nullable Component name) {
        return HoverEvent.showEntity(ShowEntity.of(type, id, name));
    }

    public static @NonNull HoverEvent<ShowEntity> showEntity(@NonNull ShowEntity entity) {
        return new HoverEvent<ShowEntity>(Action.SHOW_ENTITY, entity);
    }

    public static <V> @NonNull HoverEvent<V> hoverEvent(@NonNull Action<V> action, @NonNull V value) {
        return new HoverEvent<V>(action, value);
    }

    private HoverEvent(@NonNull Action<V> action, @NonNull V value) {
        this.action = Objects.requireNonNull(action, "action");
        this.value = Objects.requireNonNull(value, "value");
    }

    public @NonNull Action<V> action() {
        return this.action;
    }

    public @NonNull V value() {
        return this.value;
    }

    public @NonNull HoverEvent<V> value(@NonNull V value) {
        return new HoverEvent<V>(this.action, value);
    }

    public <C> @NonNull HoverEvent<V> withRenderedValue(@NonNull ComponentRenderer<C> renderer, @NonNull C context) {
        V oldValue = this.value;
        V newValue = ((Action)this.action).renderer.render(renderer, context, oldValue);
        if (newValue != oldValue) {
            return new HoverEvent<V>(this.action, newValue);
        }
        return this;
    }

    @Override
    public @NonNull HoverEvent<V> asHoverEvent() {
        return this;
    }

    @Override
    public @NonNull HoverEvent<V> asHoverEvent(@NonNull UnaryOperator<V> op) {
        if (op == UnaryOperator.identity()) {
            return this;
        }
        return new HoverEvent<V>(this.action, op.apply(this.value));
    }

    @Override
    public void styleApply( @NonNull Style.Builder style) {
        style.hoverEvent(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverEvent that = (HoverEvent)other;
        return this.action == that.action && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    public String toString() {
        return this.examine(StringExaminer.simpleEscaping());
    }

    public static final class Action<V> {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", Component.class, true, new Renderer<Component>(){

            @Override
            public <C> @NonNull Component render(@NonNull ComponentRenderer<C> renderer, @NonNull C context, @NonNull Component value) {
                return renderer.render(value, context);
            }
        });
        public static final Action<ShowItem> SHOW_ITEM = new Action<ShowItem>("show_item", ShowItem.class, true, new Renderer<ShowItem>(){

            @Override
            public <C> @NonNull ShowItem render(@NonNull ComponentRenderer<C> renderer, @NonNull C context, @NonNull ShowItem value) {
                return value;
            }
        });
        public static final Action<ShowEntity> SHOW_ENTITY = new Action<ShowEntity>("show_entity", ShowEntity.class, true, new Renderer<ShowEntity>(){

            @Override
            public <C> @NonNull ShowEntity render(@NonNull ComponentRenderer<C> renderer, @NonNull C context, @NonNull ShowEntity value) {
                if (value.name == null) {
                    return value;
                }
                return value.name(renderer.render(value.name, context));
            }
        });
        public static final Index<String, Action<?>> NAMES = Index.create(constant -> constant.name, SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY);
        private final String name;
        private final Class<V> type;
        private final boolean readable;
        private final Renderer<V> renderer;

        Action(String name, Class<V> type, boolean readable, Renderer<V> renderer) {
            this.name = name;
            this.type = type;
            this.readable = readable;
            this.renderer = renderer;
        }

        public @NonNull Class<V> type() {
            return this.type;
        }

        public boolean readable() {
            return this.readable;
        }

        public @NonNull String toString() {
            return this.name;
        }

        @FunctionalInterface
        static interface Renderer<V> {
            public <C> @NonNull V render(@NonNull ComponentRenderer<C> var1, @NonNull C var2, @NonNull V var3);
        }
    }

    public static final class ShowItem
    implements Examinable {
        private final Key item;
        private final int count;
        private final @Nullable BinaryTagHolder nbt;

        public static @NonNull ShowItem of(@NonNull Key item, @NonNegative int count) {
            return ShowItem.of(item, count, null);
        }

        public static @NonNull ShowItem of(@NonNull Keyed item, @NonNegative int count) {
            return ShowItem.of(item, count, null);
        }

        public static @NonNull ShowItem of(@NonNull Key item, @NonNegative int count, @Nullable BinaryTagHolder nbt) {
            return new ShowItem(Objects.requireNonNull(item, "item"), count, nbt);
        }

        public static @NonNull ShowItem of(@NonNull Keyed item, @NonNegative int count, @Nullable BinaryTagHolder nbt) {
            return new ShowItem(Objects.requireNonNull(item, "item").key(), count, nbt);
        }

        private ShowItem(@NonNull Key item, @NonNegative int count, @Nullable BinaryTagHolder nbt) {
            this.item = item;
            this.count = count;
            this.nbt = nbt;
        }

        public @NonNull Key item() {
            return this.item;
        }

        public @NonNull ShowItem item(@NonNull Key item) {
            if (Objects.requireNonNull(item, "item").equals(this.item)) {
                return this;
            }
            return new ShowItem(item, this.count, this.nbt);
        }

        public @NonNegative int count() {
            return this.count;
        }

        public @NonNull ShowItem count(@NonNegative int count) {
            if (count == this.count) {
                return this;
            }
            return new ShowItem(this.item, count, this.nbt);
        }

        public @Nullable BinaryTagHolder nbt() {
            return this.nbt;
        }

        public @NonNull ShowItem nbt(@Nullable BinaryTagHolder nbt) {
            if (Objects.equals(nbt, this.nbt)) {
                return this;
            }
            return new ShowItem(this.item, this.count, nbt);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ShowItem that = (ShowItem)other;
            return this.item.equals(that.item) && this.count == that.count && Objects.equals(this.nbt, that.nbt);
        }

        public int hashCode() {
            int result = this.item.hashCode();
            result = 31 * result + Integer.hashCode(this.count);
            result = 31 * result + Objects.hashCode(this.nbt);
            return result;
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("item", this.item), ExaminableProperty.of("count", this.count), ExaminableProperty.of("nbt", this.nbt));
        }

        public String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }
    }

    public static final class ShowEntity
    implements Examinable {
        private final Key type;
        private final UUID id;
        private final Component name;

        public static @NonNull ShowEntity of(@NonNull Key type, @NonNull UUID id) {
            return ShowEntity.of(type, id, null);
        }

        public static @NonNull ShowEntity of(@NonNull Keyed type, @NonNull UUID id) {
            return ShowEntity.of(type, id, null);
        }

        public static @NonNull ShowEntity of(@NonNull Key type, @NonNull UUID id, @Nullable Component name) {
            return new ShowEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(id, "id"), name);
        }

        public static @NonNull ShowEntity of(@NonNull Keyed type, @NonNull UUID id, @Nullable Component name) {
            return new ShowEntity(Objects.requireNonNull(type, "type").key(), Objects.requireNonNull(id, "id"), name);
        }

        private ShowEntity(@NonNull Key type, @NonNull UUID id, @Nullable Component name) {
            this.type = type;
            this.id = id;
            this.name = name;
        }

        public @NonNull Key type() {
            return this.type;
        }

        public @NonNull ShowEntity type(@NonNull Key type) {
            if (Objects.requireNonNull(type, "type").equals(this.type)) {
                return this;
            }
            return new ShowEntity(type, this.id, this.name);
        }

        public @NonNull ShowEntity type(@NonNull Keyed type) {
            return this.type(Objects.requireNonNull(type, "type").key());
        }

        public @NonNull UUID id() {
            return this.id;
        }

        public @NonNull ShowEntity id(@NonNull UUID id) {
            if (Objects.requireNonNull(id).equals(this.id)) {
                return this;
            }
            return new ShowEntity(this.type, id, this.name);
        }

        public @Nullable Component name() {
            return this.name;
        }

        public @NonNull ShowEntity name(@Nullable Component name) {
            if (Objects.equals(name, this.name)) {
                return this;
            }
            return new ShowEntity(this.type, this.id, name);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ShowEntity that = (ShowEntity)other;
            return this.type.equals(that.type) && this.id.equals(that.id) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.id.hashCode();
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("type", this.type), ExaminableProperty.of("id", this.id), ExaminableProperty.of("name", this.name));
        }

        public String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }
    }
}

