/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.transfer.BasicRecipeTransferHandlerServer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PacketRecipeTransfer
extends PacketJei {
    public final Map<Integer, Integer> recipeMap;
    public final List<Integer> craftingSlots;
    public final List<Integer> inventorySlots;
    public final Map<Integer, Integer> itemCounts;
    private final boolean maxTransfer;
    private final boolean requireCompleteSets;

    public PacketRecipeTransfer(Map<Integer, Integer> recipeMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this(recipeMap, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets, Collections.emptyMap());
    }

    public PacketRecipeTransfer(Map<Integer, Integer> recipeMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets, Map<Integer, Integer> itemCounts) {
        this.recipeMap = recipeMap;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
        this.itemCounts = itemCounts;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER;
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        buf.func_150787_b(this.recipeMap.size());
        for (Map.Entry<Integer, Integer> entry : this.recipeMap.entrySet()) {
            buf.func_150787_b(entry.getKey().intValue());
            buf.func_150787_b(entry.getValue().intValue());
        }
        buf.func_150787_b(this.craftingSlots.size());
        for (Integer n : this.craftingSlots) {
            buf.func_150787_b(n.intValue());
        }
        buf.func_150787_b(this.inventorySlots.size());
        for (Integer n : this.inventorySlots) {
            buf.func_150787_b(n.intValue());
        }
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
        if (!this.itemCounts.isEmpty()) {
            buf.writeBoolean(true);
            buf.func_150787_b(this.itemCounts.size());
            for (Map.Entry entry : this.itemCounts.entrySet()) {
                buf.func_150787_b(((Integer)entry.getKey()).intValue());
                buf.func_150787_b(((Integer)entry.getValue()).intValue());
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static void readPacketData(PacketBuffer buf, EntityPlayer player) {
        int recipeMapSize = buf.func_150792_a();
        HashMap<Integer, Integer> recipeMap = new HashMap<Integer, Integer>(recipeMapSize);
        for (int i = 0; i < recipeMapSize; ++i) {
            int slotIndex = buf.func_150792_a();
            int recipeItem = buf.func_150792_a();
            recipeMap.put(slotIndex, recipeItem);
        }
        int craftingSlotsSize = buf.func_150792_a();
        ArrayList<Integer> craftingSlots = new ArrayList<Integer>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotIndex = buf.func_150792_a();
            craftingSlots.add(slotIndex);
        }
        int inventorySlotsSize = buf.func_150792_a();
        ArrayList<Integer> inventorySlots = new ArrayList<Integer>(inventorySlotsSize);
        for (int i = 0; i < inventorySlotsSize; ++i) {
            int slotIndex = buf.func_150792_a();
            inventorySlots.add(slotIndex);
        }
        boolean maxTransfer = buf.readBoolean();
        boolean requireCompleteSets = buf.readBoolean();
        HashMap<Integer, Integer> itemCounts = null;
        if (buf.readBoolean()) {
            int itemCountsSize = buf.func_150792_a();
            itemCounts = new HashMap<Integer, Integer>(itemCountsSize);
            for (int i = 0; i < itemCountsSize; ++i) {
                int slotIndex = buf.func_150792_a();
                int itemCount = buf.func_150792_a();
                itemCounts.put(slotIndex, itemCount);
            }
        }
        BasicRecipeTransferHandlerServer.setItems(player, recipeMap, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets, itemCounts);
    }
}

