/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.furnace;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.plugins.vanilla.furnace.FuelRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public final class FuelRecipeMaker {
    private FuelRecipeMaker() {
    }

    public static List<FuelRecipe> getFuelRecipes(IIngredientRegistry ingredientRegistry, IJeiHelpers helpers) {
        IStackHelper stackHelper = helpers.getStackHelper();
        List<ItemStack> fuelStacks = ingredientRegistry.getFuels();
        Int2ObjectOpenHashMap fuels = new Int2ObjectOpenHashMap(fuelStacks.size() / 8);
        ArrayList<FuelRecipe> recipes = new ArrayList<FuelRecipe>(fuelStacks.size() / 8);
        for (ItemStack fuelStack : fuelStacks) {
            for (ItemStack subtype : stackHelper.getSubtypes(fuelStack)) {
                int burnTime = TileEntityFurnace.func_145952_a((ItemStack)subtype);
                ((List)fuels.computeIfAbsent((Object)burnTime, k -> new ArrayList(8))).add(subtype);
            }
        }
        IGuiHelper guiHelper = helpers.getGuiHelper();
        fuels.int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).forEach(entry -> recipes.add(new FuelRecipe(guiHelper, (Collection)entry.getValue(), entry.getIntKey())));
        return recipes;
    }
}

