/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.TokenInfo;

public class SearchToken {
    public static final SearchToken EMPTY = new SearchToken(Collections.emptyList(), Collections.emptyList());
    public final List<TokenInfo> search;
    public final List<TokenInfo> remove;

    public static SearchToken parseSearchToken(String filterText) {
        if (filterText.isEmpty()) {
            return EMPTY;
        }
        SearchToken searchTokens = new SearchToken(new ArrayList<TokenInfo>(), new ArrayList<TokenInfo>());
        Matcher filterMatcher = IngredientFilter.FILTER_SPLIT_PATTERN.matcher(filterText);
        while (filterMatcher.find()) {
            TokenInfo token;
            String string = filterMatcher.group(1);
            boolean remove = string.startsWith("-");
            if (remove) {
                string = string.substring(1);
            }
            if ((string = IngredientFilter.QUOTE_PATTERN.matcher(string).replaceAll("")).isEmpty() || (token = TokenInfo.parseRawToken(string)) == null) continue;
            if (remove) {
                searchTokens.remove.add(token);
                continue;
            }
            searchTokens.search.add(token);
        }
        return searchTokens;
    }

    public SearchToken(List<TokenInfo> search, List<TokenInfo> remove) {
        this.search = search;
        this.remove = remove;
    }

    public Set<IIngredientListElement<?>> getSearchResults(IElementSearch elementSearch) {
        Set<IIngredientListElement<IIngredientListElement<?>>> results = this.intersection(this.search.stream().map(elementSearch::getSearchResults));
        if (!results.isEmpty() && !this.remove.isEmpty()) {
            for (TokenInfo tokenInfo : this.remove) {
                Set<IIngredientListElement<?>> resultsToRemove = elementSearch.getSearchResults(tokenInfo);
                results.removeAll(resultsToRemove);
                if (!results.isEmpty()) continue;
                break;
            }
        }
        return results;
    }

    private <T> Set<T> intersection(Stream<Set<T>> stream) {
        Set set;
        List sets = stream.collect(Collectors.toList());
        Set smallestSet = sets.stream().min(Comparator.comparing(Set::size)).orElseGet(Collections::emptySet);
        ReferenceOpenHashSet results = new ReferenceOpenHashSet((Collection)smallestSet);
        Iterator iterator = sets.iterator();
        while (!(!iterator.hasNext() || (set = (Set)iterator.next()) != smallestSet && results.retainAll(set) && results.isEmpty())) {
        }
        return results;
    }
}

