/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import mustapelto.deepmoblearning.DMLConstants;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;

public class ModelDataModel
implements IModel {
    private static final ResourceLocation BASE_LOCATION = new ResourceLocation("deepmoblearning", "items/data_model_base");
    private static final ResourceLocation BLANK_LOCATION = new ResourceLocation("deepmoblearning", "items/data_model_blank");
    private final ResourceLocation mobLocation;

    public ModelDataModel(ResourceLocation mobLocation) {
        this.mobLocation = mobLocation;
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableSet.of((Object)BASE_LOCATION, (Object)this.mobLocation);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableSet.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        state = ForgeBlockStateV1.Transforms.get((String)"forge:default-item").orElse(state);
        ItemLayerModel model = new ItemLayerModel(ImmutableList.of((Object)BASE_LOCATION, (Object)this.mobLocation));
        return model.bake(state, format, bakedTextureGetter);
    }

    public static enum LoaderDataModel implements ICustomModelLoader
    {
        INSTANCE;

        private final Map<String, ResourceLocation> textureCache = new HashMap<String, ResourceLocation>();
        private final Map<String, ModelDataModel> modelCache = new HashMap<String, ModelDataModel>();

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("deepmoblearning") && modelLocation.func_110623_a().contains("data_model");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            String mobId = modelLocation.func_110623_a().substring("data_model_".length());
            if (!this.modelCache.containsKey(mobId)) {
                ModelDataModel model = new ModelDataModel(this.textureCache.getOrDefault(mobId, DMLConstants.DefaultModels.DATA_MODEL));
                this.modelCache.put(mobId, model);
            }
            return this.modelCache.get(mobId);
        }

        public void func_110549_a(IResourceManager resourceManager) {
            this.initTextureCache();
        }

        private void initTextureCache() {
            this.textureCache.clear();
            this.textureCache.put("blank", BLANK_LOCATION);
            this.textureCache.putAll((Map<String, ResourceLocation>)MetadataManager.getDataModelTextures());
            this.modelCache.clear();
        }
    }
}

