/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.entities;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.DMLRegistry;
import mustapelto.deepmoblearning.common.ServerProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityItemGlitchFragment
extends EntityItem {
    private int progress = 0;

    public EntityItemGlitchFragment(World worldIn) {
        super(worldIn);
    }

    public EntityItemGlitchFragment(World worldIn, double x, double y, double z, ItemStack stack) {
        super(worldIn, x, y, z);
        this.func_92058_a(stack);
        this.func_174867_a(15);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70090_H()) {
            boolean requiredEntitiesPresent;
            AxisAlignedBB box = new AxisAlignedBB(this.field_70165_t - 1.0, this.field_70163_u - 1.0, this.field_70161_v - 1.0, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0);
            List bbContainedItems = this.field_70170_p.func_72872_a(EntityItem.class, box);
            EntityItem goldEntity = EntityItemGlitchFragment.getAnyInList(bbContainedItems, new ItemStack(Items.field_151043_k));
            EntityItem lapisEntity = EntityItemGlitchFragment.getAnyInList(bbContainedItems, new ItemStack(Items.field_151100_aR, 1, 4));
            EntityItem glitchFragmentEntity = EntityItemGlitchFragment.getAnyInList(bbContainedItems, new ItemStack((Item)DMLRegistry.ITEM_GLITCH_FRAGMENT));
            ++this.progress;
            boolean bl = requiredEntitiesPresent = goldEntity != null && lapisEntity != null && glitchFragmentEntity != null;
            if (this.field_70170_p.field_72995_K) {
                this.spawnFragmentParticles();
                if (requiredEntitiesPresent) {
                    for (int i = 0; i < 3; ++i) {
                        this.spawnFragmentParticles();
                    }
                }
            }
            if (!requiredEntitiesPresent) {
                this.progress = 0;
                return;
            }
            if (!this.field_70170_p.field_72995_K && this.progress >= 35) {
                this.shrink(goldEntity);
                this.shrink(lapisEntity);
                this.shrink(glitchFragmentEntity);
                this.spawnIngot();
            }
        }
    }

    @Nullable
    private static EntityItem getAnyInList(List<EntityItem> input, ItemStack filter) {
        return input.stream().filter(entityItem -> EntityItemGlitchFragment.isEntityItemEqual(entityItem, filter)).findAny().orElse(null);
    }

    private static boolean isEntityItemEqual(EntityItem entityItem, ItemStack item2) {
        ItemStack item1 = entityItem.func_92059_d();
        if (item1.func_190926_b() || item2.func_190926_b()) {
            return false;
        }
        return item1.func_77969_a(item2);
    }

    private void shrink(EntityItem entityItem) {
        ItemStack item = entityItem.func_92059_d();
        item.func_190918_g(1);
        if (item.func_190926_b()) {
            entityItem.func_70106_y();
        }
    }

    private void spawnFragmentParticles() {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        DMLRelearned.proxy.spawnSmokeParticle(this.field_70170_p, this.field_70165_t + random.nextDouble(-0.25, 0.25), this.field_70163_u + random.nextDouble(-0.1, 0.8), this.field_70161_v + random.nextDouble(-0.25, 0.25), random.nextDouble(-0.08, 0.08), random.nextDouble(-0.08, 0.22), random.nextDouble(-0.08, 0.08), ServerProxy.SmokeType.CYAN);
    }

    private void spawnIngot() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        EntityItem ingot = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.6, this.field_70161_v, new ItemStack((Item)DMLRegistry.ITEM_GLITCH_INGOT, 1));
        ingot.field_70159_w = random.nextDouble(-0.2, 0.2);
        ingot.field_70181_x = 0.0;
        ingot.field_70179_y = random.nextDouble(-0.2, 0.2);
        ingot.func_174869_p();
        this.field_70170_p.func_72838_d((Entity)ingot);
    }
}

