/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.inventory;

import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.inventory.ItemHandlerBase;
import mustapelto.deepmoblearning.common.items.ItemPristineMatter;
import mustapelto.deepmoblearning.common.metadata.MetadataDataModel;
import mustapelto.deepmoblearning.common.util.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemHandlerPristineMatter
extends ItemHandlerBase {
    @Nullable
    protected MetadataDataModel pristineMatterMetadata;

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return ItemStackHelper.isPristineMatter(stack) ? super.insertItem(slot, stack, simulate) : stack;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.updateMetadata();
    }

    protected void onContentsChanged(int slot) {
        if (slot != 0) {
            return;
        }
        this.updateMetadata();
    }

    @Nullable
    public MetadataDataModel getPristineMatterMetadata() {
        return this.pristineMatterMetadata;
    }

    private void updateMetadata() {
        MetadataDataModel newMetadata = ItemPristineMatter.getDataModelMetadata(this.getStackInSlot(0)).orElse(null);
        if (newMetadata != this.pristineMatterMetadata) {
            this.pristineMatterMetadata = newMetadata;
            this.onMetadataChanged();
        }
    }

    protected abstract void onMetadataChanged();
}

