/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.DMLRelearned;
import mustapelto.deepmoblearning.common.items.ItemGlitchIngot;
import mustapelto.deepmoblearning.common.util.NBTHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGlitchSword
extends ItemSword {
    private static final Item.ToolMaterial material = EnumHelper.addToolMaterial((String)"GLITCH_INFUSED_MATERIAL", (int)3, (int)2200, (float)8.0f, (float)9.0f, (int)15);

    public ItemGlitchSword() {
        super(material);
        String name = "glitch_infused_sword";
        this.setRegistryName(name);
        this.func_77655_b("deepmoblearning." + name);
        this.func_77637_a(DMLRelearned.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.glitch_sword.tooltip_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.glitch_sword.tooltip_2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"deepmoblearning.glitch_sword.tooltip_3", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.glitch_sword.tooltip_4", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.glitch_sword.tooltip_5", (Object[])new Object[0]) + TextFormatting.RESET);
        String damage = TextFormatting.AQUA + String.valueOf(ItemGlitchSword.getPermanentWeaponDamage(stack)) + TextFormatting.RESET;
        tooltip.add(I18n.func_135052_a((String)"deepmoblearning.glitch_sword.tooltip_6", (Object[])new Object[]{damage, 18}));
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() instanceof ItemGlitchIngot;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        AttributeModifier attackDamage = new AttributeModifier(field_111210_e, "Weapon modifier", (double)(material.func_78000_c() + (float)ItemGlitchSword.getPermanentWeaponDamage(stack)), 0);
        AttributeModifier attackSpeed = new AttributeModifier(field_185050_h, "Weapon modifier", -2.4, 0);
        HashMultimap modifiers = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)attackDamage);
            modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)attackSpeed);
        }
        return modifiers;
    }

    private static int getPermanentWeaponDamage(ItemStack stack) {
        return NBTHelper.getInteger(stack, "permDamage", 0);
    }

    private static void setPermanentWeaponDamage(ItemStack stack, int damage) {
        NBTHelper.setInteger(stack, "permDamage", damage);
    }

    public static boolean canIncreaseDamage(ItemStack stack) {
        return ItemGlitchSword.getPermanentWeaponDamage(stack) < 18;
    }

    public static void increaseDamage(ItemStack stack, EntityPlayerMP player) {
        if (ThreadLocalRandom.current().nextInt(1, 100) < 6) {
            int currentDamage = ItemGlitchSword.getPermanentWeaponDamage(stack);
            int newDamage = currentDamage + 2;
            if (newDamage > 18) {
                newDamage = 18;
            }
            ItemGlitchSword.setPermanentWeaponDamage(stack, newDamage);
            if (newDamage >= 18) {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"deepmoblearning.glitch_sword.max_damage_reached", (Object[])new Object[]{stack.func_82833_r()})));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"deepmoblearning.glitch_sword.damage_increased", (Object[])new Object[]{stack.func_82833_r()})));
            }
        }
    }
}

