/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.client.util.KeyboardHelper;
import mustapelto.deepmoblearning.common.items.ItemBase;
import mustapelto.deepmoblearning.common.metadata.MetadataManager;
import mustapelto.deepmoblearning.common.trials.AttunementData;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import mustapelto.deepmoblearning.common.util.StringHelper;
import mustapelto.deepmoblearning.common.util.TrialKeyHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemTrialKey
extends ItemBase {
    public ItemTrialKey() {
        super("trial_key", 1);
    }

    public String func_77653_i(ItemStack stack) {
        return StringHelper.getFormattedString(super.func_77653_i(stack), TextFormatting.AQUA);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!KeyboardHelper.isHoldingSneakKey()) {
            String sneakString = StringHelper.getFormattedString(TextFormatting.ITALIC, KeyboardHelper.getSneakKeyName(), TextFormatting.GRAY);
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"deepmoblearning.general.more_info", (Object[])new Object[]{sneakString}) + TextFormatting.RESET);
        } else {
            AttunementData attunementData = TrialKeyHelper.getAttunement(stack).orElse(null);
            if (attunementData == null) {
                tooltip.add(StringHelper.getFormattedString(I18n.func_135052_a((String)"deepmoblearning.trial_key.tooltip.not_attuned", (Object[])new Object[0]), TextFormatting.GRAY));
                tooltip.add(StringHelper.getFormattedString(I18n.func_135052_a((String)"deepmoblearning.trial_key.tooltip.available_attunements", (Object[])new Object[0]), TextFormatting.AQUA));
                ImmutableList<String> availableTrials = MetadataManager.getAvailableTrials();
                for (String trial : availableTrials) {
                    tooltip.add(StringHelper.getFormattedString("  - " + trial, TextFormatting.WHITE));
                }
            } else {
                String mobName = StringHelper.getFormattedString(attunementData.getMobDisplayName(), TextFormatting.GRAY);
                tooltip.add(I18n.func_135052_a((String)"deepmoblearning.trial_key.tooltip.attunement", (Object[])new Object[]{mobName}));
                String tierName = attunementData.getTierDisplayNameFormatted();
                tooltip.add(I18n.func_135052_a((String)"deepmoblearning.trial_key.tooltip.tier", (Object[])new Object[]{tierName}));
                ImmutableList<TrialAffix> affixes = TrialKeyHelper.getAffixes(stack, BlockPos.field_177992_a, worldIn);
                if (affixes.isEmpty()) {
                    tooltip.add(I18n.func_135052_a((String)"deepmoblearning.trial_key.tooltip.affixes_faulty", (Object[])new Object[0]));
                } else {
                    StringBuilder affixList = new StringBuilder();
                    for (int i = 0; i < affixes.size(); ++i) {
                        affixList.append(((TrialAffix)affixes.get(i)).getAffixName()).append(i == affixes.size() - 1 ? " " : ", ");
                    }
                    tooltip.add(I18n.func_135052_a((String)"deepmoblearning.trial_key.tooltip.affixes", (Object[])new Object[]{affixList.toString()}));
                    tooltip.add(I18n.func_135052_a((String)"deepmoblearning.trial_key.tooltip.affix_info", (Object[])new Object[0]));
                }
            }
        }
    }
}

