/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.tiles.RedstoneMode;
import mustapelto.deepmoblearning.common.tiles.TileEntityMachine;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageRedstoneMode
implements IMessage {
    private BlockPos pos;
    private int dimension;
    private RedstoneMode redstoneMode;

    public MessageRedstoneMode() {
    }

    public MessageRedstoneMode(BlockPos pos, int dimension, RedstoneMode redstoneMode) {
        this.pos = pos;
        this.dimension = dimension;
        this.redstoneMode = redstoneMode;
    }

    public MessageRedstoneMode(TileEntityMachine target, RedstoneMode redstoneMode) {
        this(target.func_174877_v(), target.func_145831_w().field_73011_w.getDimension(), redstoneMode);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
        buf.writeInt(this.redstoneMode.getIndex());
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.dimension = buf.readInt();
        this.redstoneMode = RedstoneMode.byIndex(buf.readInt());
    }

    public static class Handler
    implements IMessageHandler<MessageRedstoneMode, IMessage> {
        @Nullable
        public IMessage onMessage(MessageRedstoneMode message, MessageContext ctx) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            world.func_152344_a(() -> {
                TileEntityMachine te = (TileEntityMachine)world.func_175625_s(message.pos);
                if (te != null) {
                    te.setRedstoneMode(message.redstoneMode);
                }
            });
            return null;
        }
    }
}

