/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.tiles;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.energy.DMLEnergyStorage;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageCraftingState;
import mustapelto.deepmoblearning.common.tiles.CraftingState;
import mustapelto.deepmoblearning.common.tiles.RedstoneMode;
import mustapelto.deepmoblearning.common.tiles.TileEntityLootFabricator;
import mustapelto.deepmoblearning.common.tiles.TileEntitySimulationChamber;
import mustapelto.deepmoblearning.common.tiles.TileEntityTickable;
import mustapelto.deepmoblearning.common.util.NBTHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class TileEntityMachine
extends TileEntityTickable {
    protected final DMLEnergyStorage energyStorage;
    protected boolean redstonePowered;
    protected int redstoneLevel;
    protected RedstoneMode redstoneMode = RedstoneMode.ALWAYS_ON;
    private CraftingState craftingState = CraftingState.IDLE;
    protected boolean crafting = false;
    protected int craftingProgress = 0;
    private static final String NBT_REDSTONE = "redstone";
    private static final String NBT_REDSTONE_LEVEL = "level";
    private static final String NBT_REDSTONE_POWERED = "powered";
    private static final String NBT_REDSTONE_MODE = "mode";
    protected static final String NBT_CRAFTING = "crafting";
    private static final String NBT_IS_CRAFTING = "isCrafting";
    private static final String NBT_CRAFTING_PROGRESS = "progress";
    private static final String NBT_LEGACY_CRAFTING_PROGRESS_SIM_CHAMBER = "simulationProgress";
    private static final String NBT_LEGACY_CRAFTING_PROGRESS_LOOT_FAB = "crafingProgress";

    public TileEntityMachine(int energyCapacity, int energyMaxReceive) {
        this.energyStorage = new DMLEnergyStorage(energyCapacity, energyMaxReceive){

            @Override
            protected void onEnergyChanged() {
                TileEntityMachine.this.func_70296_d();
            }
        };
    }

    @Override
    public void func_73660_a() {
        CraftingState newCraftingState;
        super.func_73660_a();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.crafting && this.canStartCrafting()) {
            this.startCrafting();
        }
        if (this.crafting && this.canContinueCrafting()) {
            this.energyStorage.voidEnergy(this.getCraftingEnergyCost());
            this.advanceCraftingProgress();
        }
        if (this.craftingState != (newCraftingState = this.updateCraftingState())) {
            this.craftingState = newCraftingState;
            DMLPacketHandler.sendToClient(new MessageCraftingState(this), this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
    }

    protected void startCrafting() {
        this.crafting = true;
        this.func_70296_d();
    }

    protected boolean canStartCrafting() {
        return this.canContinueCrafting();
    }

    protected boolean canContinueCrafting() {
        return this.isRedstoneActive() && this.hasEnergyForCrafting();
    }

    private void advanceCraftingProgress() {
        ++this.craftingProgress;
        if (this.craftingProgress >= this.getCraftingDuration()) {
            this.finishCrafting();
        }
        this.func_70296_d();
    }

    protected abstract int getCraftingDuration();

    protected abstract void finishCrafting();

    protected void resetCrafting() {
        this.crafting = false;
        this.craftingProgress = 0;
        this.func_70296_d();
    }

    public float getRelativeCraftingProgress() {
        return (float)this.craftingProgress / (float)this.getCraftingDuration();
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public boolean hasEnergyForCrafting() {
        return this.energyStorage.getEnergyStored() >= this.getCraftingEnergyCost();
    }

    public abstract int getCraftingEnergyCost();

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    protected abstract CraftingState updateCraftingState();

    public CraftingState getCraftingState() {
        return this.craftingState;
    }

    public void setCraftingState(CraftingState newState) {
        this.craftingState = newState;
        this.sendBlockUpdate();
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.sendUpdatePacketToClient();
    }

    public boolean isRedstoneActive() {
        return RedstoneMode.isActive(this.redstoneMode, this.redstonePowered);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public ByteBuf getUpdateData() {
        ByteBuf buf = super.getUpdateData();
        this.energyStorage.writeToBuffer(buf);
        buf.writeInt(this.redstoneLevel);
        buf.writeBoolean(this.redstonePowered);
        buf.writeInt(this.redstoneMode.getIndex());
        buf.writeBoolean(this.crafting);
        buf.writeInt(this.craftingProgress);
        buf.writeInt(this.craftingState.getIndex());
        return buf;
    }

    @Override
    public void handleUpdateData(ByteBuf buf) {
        this.energyStorage.readFromBuffer(buf);
        this.redstoneLevel = buf.readInt();
        this.redstonePowered = buf.readBoolean();
        this.redstoneMode = RedstoneMode.byIndex(buf.readInt());
        this.crafting = buf.readBoolean();
        this.craftingProgress = buf.readInt();
        this.craftingState = CraftingState.byIndex(buf.readInt());
        this.sendBlockUpdate();
    }

    public void onBlockPlaced() {
        this.onNeighborChange();
    }

    public void onNeighborChange() {
        boolean oldRedstonePowerState = this.redstonePowered;
        this.redstoneLevel = this.field_145850_b.func_175687_A(this.field_174879_c);
        boolean bl = this.redstonePowered = this.redstoneLevel > 0;
        if (this.redstonePowered != oldRedstonePowerState) {
            if (!this.field_145850_b.field_72995_K) {
                this.sendUpdatePacketToClient();
            } else {
                this.sendBlockUpdate();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.energyStorage.writeToNBT(compound);
        NBTTagCompound redstoneTag = new NBTTagCompound();
        redstoneTag.func_74768_a(NBT_REDSTONE_LEVEL, this.redstoneLevel);
        redstoneTag.func_74757_a(NBT_REDSTONE_POWERED, this.redstonePowered);
        redstoneTag.func_74768_a(NBT_REDSTONE_MODE, this.redstoneMode.getIndex());
        compound.func_74782_a(NBT_REDSTONE, (NBTBase)redstoneTag);
        NBTTagCompound craftingTag = new NBTTagCompound();
        craftingTag.func_74757_a(NBT_IS_CRAFTING, this.crafting);
        craftingTag.func_74768_a(NBT_CRAFTING_PROGRESS, this.craftingProgress);
        compound.func_74782_a(NBT_CRAFTING, (NBTBase)craftingTag);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energyStorage.readFromNBT(compound);
        NBTTagCompound redstoneTag = compound.func_74775_l(NBT_REDSTONE);
        this.redstoneLevel = NBTHelper.getInteger(redstoneTag, NBT_REDSTONE_LEVEL, 0);
        this.redstonePowered = NBTHelper.getBoolean(redstoneTag, NBT_REDSTONE_POWERED, false);
        this.redstoneMode = RedstoneMode.byIndex(NBTHelper.getInteger(redstoneTag, NBT_REDSTONE_MODE, 0));
        if (TileEntityMachine.isLegacyNBT(compound)) {
            this.crafting = NBTHelper.getBoolean(compound, NBT_IS_CRAFTING, false);
            if (this instanceof TileEntitySimulationChamber) {
                this.craftingProgress = NBTHelper.getInteger(compound, NBT_LEGACY_CRAFTING_PROGRESS_SIM_CHAMBER, 0);
            } else if (this instanceof TileEntityLootFabricator) {
                this.craftingProgress = NBTHelper.getInteger(compound, NBT_LEGACY_CRAFTING_PROGRESS_LOOT_FAB, 0);
            }
        } else {
            NBTTagCompound craftingTag = compound.func_74775_l(NBT_CRAFTING);
            this.crafting = NBTHelper.getBoolean(craftingTag, NBT_IS_CRAFTING, false);
            this.craftingProgress = NBTHelper.getInteger(craftingTag, NBT_CRAFTING_PROGRESS, 0);
        }
    }

    private static boolean isLegacyNBT(NBTTagCompound nbt) {
        return nbt.func_74764_b(NBT_IS_CRAFTING) || nbt.func_74764_b(NBT_LEGACY_CRAFTING_PROGRESS_LOOT_FAB) || nbt.func_74764_b(NBT_LEGACY_CRAFTING_PROGRESS_SIM_CHAMBER);
    }
}

