/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.tiles;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import mustapelto.deepmoblearning.common.entities.EntityGlitch;
import mustapelto.deepmoblearning.common.network.DMLPacketHandler;
import mustapelto.deepmoblearning.common.network.MessageUpdateTileEntity;
import mustapelto.deepmoblearning.common.tiles.TileEntityTrialKeystone;
import mustapelto.deepmoblearning.common.trials.AttunementData;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import mustapelto.deepmoblearning.common.util.BlockDistance;
import mustapelto.deepmoblearning.common.util.EntityHelper;
import mustapelto.deepmoblearning.common.util.PlayerHelper;
import mustapelto.deepmoblearning.common.util.SoundHelper;
import mustapelto.deepmoblearning.common.util.TrialKeyHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TrialHandler {
    private final TileEntityTrialKeystone te;
    private final Set<EntityPlayerMP> participants = Collections.newSetFromMap(new WeakHashMap());
    private ItemStack activeTrialKey = ItemStack.field_190927_a;
    private boolean active;
    private int currentWave;
    private int mobsDefeated;
    private int mobsSpawned;
    private int ticksToNextWave;
    private AttunementData data;
    private ImmutableList<TrialAffix> affixes;
    private static final String NBT_ACTIVE_TRIAL_KEY = "activeTrialKey";
    private static final String NBT_CURRENT_WAVE = "currentWave";
    private static final String NBT_MOBS_DEFEATED = "mobsDefeated";
    private static final String NBT_IS_ACTIVE = "active";

    protected TrialHandler(TileEntityTrialKeystone te) {
        this.te = te;
    }

    protected void runTrial() {
        this.disableFlying();
        this.removeDistantParticipants();
        if (this.participants.isEmpty()) {
            List<EntityPlayerMP> nearbyPlayers = PlayerHelper.getLivingPlayersInArea(this.getWorld(), this.getPos(), 80, 60, -30);
            nearbyPlayers.forEach(p -> p.func_145747_a((ITextComponent)new TextComponentTranslation("deepmoblearning.trial.message.failed", new Object[0])));
            nearbyPlayers.forEach(PlayerHelper::resetTrialCapability);
            this.stopTrial(true, false);
            return;
        }
        if (this.ticksToNextWave > 0) {
            --this.ticksToNextWave;
            if (this.ticksToNextWave == 0) {
                this.startNextWave();
            }
            return;
        }
        if (this.currentWave <= this.getLastWave()) {
            if (this.mobsSpawned < this.getWaveMobTotal() && (double)this.getTimer() % (20.0 * this.getSpawnDelay()) == 0.0) {
                EntityHelper.spawnTrialMob(this.getRandomTrialEntity(), this.getWorld(), this.getPos(), this.getAffixes());
                ++this.mobsSpawned;
            }
            if (this.mobsDefeated >= this.getWaveMobTotal()) {
                if (this.currentWave == this.getLastWave() - 1) {
                    this.stopTrial(false, true);
                    return;
                }
                this.ticksToNextWave = 100;
                this.participants.forEach(participant -> PlayerHelper.sendMessageToOverlay(participant, "WaveCountdown"));
                SoundHelper.playSound(this.getWorld(), this.getPos(), "waveCountdown");
            }
        } else {
            this.resetTrial();
            return;
        }
        this.getAffixes().forEach(TrialAffix::run);
        if (this.getTimer() % 280L == 0L) {
            this.spawnGlitch();
        }
    }

    protected boolean startTrial(ItemStack trialKey) {
        this.activeTrialKey = trialKey.func_77946_l();
        if (this.getData() == null) {
            this.stopTrial(true, false);
        }
        this.participants.addAll(PlayerHelper.getLivingPlayersInArea(this.getWorld(), this.getPos(), 7, 9, 0));
        this.active = true;
        this.updateCapability();
        this.onWaveStart();
        return true;
    }

    protected void stopTrial(boolean abort, boolean sendMessages) {
        this.getAffixes().forEach(TrialAffix::cleanUp);
        if (!abort) {
            if (sendMessages) {
                this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "TrialCompleted"));
                SoundHelper.playSound(this.getWorld(), this.getPos(), "trialWon");
            }
            ImmutableList<ItemStack> rewards = this.getRewards();
            rewards.forEach(stack -> {
                EntityItem item = new EntityItem(this.getWorld(), (double)this.getPos().func_177958_n(), (double)(this.getPos().func_177956_o() + 2), (double)this.getPos().func_177952_p(), stack);
                item.func_174869_p();
                this.getWorld().func_72838_d((Entity)item);
            });
        } else if (this.isTrialActive() && sendMessages) {
            this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "TrialAborted"));
        }
        this.resetTrial();
    }

    private void onWaveStart() {
        SoundHelper.playSound(this.getWorld(), this.getPos(), "waveStart");
        this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "WaveNumber"));
    }

    private void startNextWave() {
        ++this.currentWave;
        this.mobsDefeated = 0;
        this.mobsSpawned = 0;
        this.participants.clear();
        this.participants.addAll(PlayerHelper.getLivingPlayersInArea(this.getWorld(), this.getPos(), 7, 9, 0));
        this.participants.forEach(p -> DMLPacketHandler.sendToClientPlayer(new MessageUpdateTileEntity(this.te), p));
        this.updateCapability();
        this.onWaveStart();
    }

    protected void onPlayerDied(EntityPlayerMP player) {
        this.participants.remove(player);
        PlayerHelper.resetTrialCapability(player);
    }

    protected void onMobDied() {
        ++this.mobsDefeated;
        this.updateCapability();
    }

    protected boolean isTrialActive() {
        return this.active;
    }

    private void disableFlying() {
        this.participants.forEach(p -> {
            if (!p.field_70128_L && !p.field_71075_bZ.field_75098_d && p.field_71075_bZ.field_75101_c) {
                p.field_71075_bZ.field_75101_c = false;
                p.field_71075_bZ.field_75100_b = false;
                p.func_71016_p();
            }
        });
    }

    private void removeDistantParticipants() {
        Iterator<EntityPlayerMP> iterator = this.participants.iterator();
        while (iterator.hasNext()) {
            EntityPlayerMP player = iterator.next();
            double distance = BlockDistance.getBlockDistance(this.getPos(), player.func_180425_c());
            if (!(distance > 21.0)) continue;
            player.func_145747_a((ITextComponent)new TextComponentTranslation("deepmoblearning.trial.message.player_left", new Object[0]));
            PlayerHelper.resetTrialCapability(player);
            iterator.remove();
        }
    }

    private void spawnGlitch() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int randomX = this.getPos().func_177958_n() + rand.nextInt(-5, 5);
        int randomY = this.getPos().func_177956_o() + rand.nextInt(0, 1);
        int randomZ = this.getPos().func_177952_p() + rand.nextInt(-5, 5);
        if (rand.nextInt(1, 100) <= this.getGlitchChance()) {
            EntityGlitch e = new EntityGlitch(this.getWorld());
            e.func_70012_b(randomX, randomY, randomZ, 0.0f, 0.0f);
            e.func_110163_bv();
            EntityPlayer target = e.field_70170_p.func_184139_a(e.func_180425_c(), 32.0, 5.0);
            if (target != null && target.func_70089_S()) {
                e.func_70624_b((EntityLivingBase)target);
            }
            this.getAffixes().forEach(affix -> affix.applyToGlitch(e));
            this.getWorld().func_72838_d((Entity)e);
            this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "GlitchNotification"));
            SoundHelper.playSound(this.getWorld(), this.getPos(), "glitchAlert");
        }
    }

    protected boolean isTrialAreaClear() {
        int groundY = this.getPos().func_177956_o() - 1;
        int keystoneY = this.getPos().func_177956_o();
        int areaMaxY = this.getPos().func_177956_o() + 9;
        int areaMinX = this.getPos().func_177958_n() - 7;
        int areaMaxX = this.getPos().func_177958_n() + 7;
        int areaMinZ = this.getPos().func_177952_p() - 7;
        int areaMaxZ = this.getPos().func_177952_p() + 7;
        Iterable groundLayer = BlockPos.func_191532_a((int)areaMinX, (int)groundY, (int)areaMinZ, (int)areaMaxX, (int)groundY, (int)areaMaxZ);
        for (BlockPos blockPos : groundLayer) {
            if (this.getWorld().func_180495_p(blockPos).func_185913_b()) continue;
            return false;
        }
        Iterable airLayer = BlockPos.func_191532_a((int)areaMinX, (int)keystoneY, (int)areaMinZ, (int)areaMaxX, (int)areaMaxY, (int)areaMaxZ);
        for (BlockPos blockPos : airLayer) {
            IBlockState state;
            Block block;
            if (blockPos.equals((Object)this.getPos()) || (block = (state = this.getWorld().func_180495_p(blockPos)).func_177230_c()).isAir(state, (IBlockAccess)this.getWorld(), blockPos)) continue;
            return false;
        }
        return true;
    }

    private void updateCapability() {
        PlayerHelper.updateTrialCapability(this.participants, this.getWaveMobTotal(), this.currentWave, this.mobsDefeated, this.getLastWave(), this.getPos(), this.active);
    }

    protected void resetTrial() {
        this.active = false;
        this.mobsSpawned = 0;
        this.mobsDefeated = 0;
        this.currentWave = 0;
        this.ticksToNextWave = 0;
        this.activeTrialKey = ItemStack.field_190927_a;
        this.updateCapability();
        this.participants.clear();
    }

    protected int getCurrentWave() {
        return this.currentWave;
    }

    protected int getLastWave() {
        AttunementData data = this.getData();
        return data != null ? data.getMaxWave() : 0;
    }

    private int getWaveMobTotal() {
        AttunementData data = this.getData();
        return data != null ? data.getCurrentWaveMobTotal(this.currentWave) : 0;
    }

    private double getSpawnDelay() {
        AttunementData data = this.getData();
        return data != null ? data.getSpawnDelay() : 0.0;
    }

    private int getGlitchChance() {
        AttunementData data = this.getData();
        return data != null ? data.getGlitchChance() : 0;
    }

    @Nullable
    private EntityLiving getRandomTrialEntity() {
        AttunementData data = this.getData();
        if (data != null) {
            return data.getRandomEntity(this.getWorld()).orElse(null);
        }
        return null;
    }

    protected ImmutableList<ItemStack> getRewards() {
        AttunementData data = this.getData();
        return data != null ? data.getRewards() : ImmutableList.of();
    }

    private BlockPos getPos() {
        return this.te.func_174877_v();
    }

    private World getWorld() {
        return this.te.func_145831_w();
    }

    private long getTimer() {
        return this.te.getTimer();
    }

    protected ImmutableList<TrialAffix> getAffixes() {
        ImmutableList<TrialAffix> affixes = ImmutableList.of();
        if (this.activeTrialKey != ItemStack.field_190927_a) {
            affixes = this.affixes == null ? (this.affixes = TrialKeyHelper.getAffixes(this.activeTrialKey, this.getPos(), this.getWorld())) : this.affixes;
        } else {
            this.affixes = ImmutableList.of();
        }
        return affixes;
    }

    @Nullable
    private AttunementData getData() {
        AttunementData data = null;
        if (this.activeTrialKey != ItemStack.field_190927_a) {
            data = this.data == null ? (this.data = (AttunementData)TrialKeyHelper.getAttunement(this.activeTrialKey).orElse(null)) : this.data;
        } else {
            this.data = null;
        }
        return data;
    }

    protected ByteBuf getUpdateData(ByteBuf buf) {
        buf.writeBoolean(this.active);
        buf.writeInt(this.currentWave);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.activeTrialKey);
        return buf;
    }

    protected void handleUpdateData(ByteBuf buf) {
        this.active = buf.readBoolean();
        this.currentWave = buf.readInt();
        this.activeTrialKey = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    protected void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a(NBT_IS_ACTIVE, this.active);
        compound.func_74768_a(NBT_CURRENT_WAVE, this.currentWave);
        compound.func_74768_a(NBT_MOBS_DEFEATED, this.mobsDefeated);
        if (this.activeTrialKey != null) {
            NBTTagCompound trialKey = this.activeTrialKey.func_77955_b(new NBTTagCompound());
            compound.func_74782_a(NBT_ACTIVE_TRIAL_KEY, (NBTBase)trialKey);
        }
    }

    protected void readFromNBT(NBTTagCompound compound) {
        this.active = compound.func_74767_n(NBT_IS_ACTIVE);
        this.currentWave = compound.func_74762_e(NBT_CURRENT_WAVE);
        this.mobsSpawned = this.mobsDefeated = compound.func_74762_e(NBT_MOBS_DEFEATED);
        NBTTagCompound trialKey = compound.func_74775_l(NBT_ACTIVE_TRIAL_KEY);
        this.activeTrialKey = new ItemStack(trialKey);
    }
}

