/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.trials.affix;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class LootHoarderAffix
extends TrialAffix {
    private int ticks = 0;

    public LootHoarderAffix() {
    }

    public LootHoarderAffix(BlockPos pos, World world) {
        super(pos, world);
    }

    @Override
    public String getId() {
        return "loot_hoarders";
    }

    @Override
    public LootHoarderAffix copy(BlockPos pos, World world) {
        return new LootHoarderAffix(pos, world);
    }

    @Override
    public void run() {
        ++this.ticks;
        if (this.ticks % 300 == 0) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            if (rand.nextInt(1, 100) > 75) {
                EntityZombie hoarder = new EntityZombie(this.world);
                hoarder.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151169_ag));
                hoarder.func_96094_a("Loot Hoarder");
                hoarder.func_82227_f(true);
                int randomX = this.pos.func_177958_n() + rand.nextInt(-5, 5);
                int randomY = this.pos.func_177956_o() + rand.nextInt(0, 1);
                int randomZ = this.pos.func_177952_p() + rand.nextInt(-5, 5);
                hoarder.func_70012_b((double)randomX, (double)randomY, (double)randomZ, 0.0f, 0.0f);
                hoarder.getEntityData().func_74778_a("deepmoblearning:mob_type", "loot_hoarders");
                hoarder.func_110163_bv();
                LootTable table = this.world.func_184146_ak().func_186521_a(new ResourceLocation("deepmoblearning", "loot_hoarder"));
                LootContext ctx = new LootContext.Builder((WorldServer)this.world).func_186471_a();
                List looted = table.func_186462_a(this.world.field_73012_v, ctx);
                if (looted.size() > 0) {
                    hoarder.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)looted.get(0));
                }
                this.world.func_72838_d((Entity)hoarder);
            }
            this.ticks = 0;
        }
    }

    @Override
    public String getAffixName() {
        return TextFormatting.GOLD + I18n.func_135052_a((String)"deepmoblearning.affix.loot_hoarder.name", (Object[])new Object[0]) + TextFormatting.RESET;
    }
}

