/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.trials.affix;

import java.util.concurrent.ThreadLocalRandom;
import mustapelto.deepmoblearning.common.trials.affix.TrialAffix;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;

public class ThunderDomeAffix
extends TrialAffix {
    private int ticks = 0;
    private final boolean wasRaining;
    private final boolean wasThundering;

    public ThunderDomeAffix() {
        this.wasRaining = false;
        this.wasThundering = false;
    }

    public ThunderDomeAffix(BlockPos pos, World world) {
        super(pos, world);
        this.wasRaining = world.func_72912_H().func_76059_o();
        this.wasThundering = world.func_72912_H().func_76061_m();
    }

    @Override
    public ThunderDomeAffix copy(BlockPos pos, World world) {
        return new ThunderDomeAffix(pos, world);
    }

    @Override
    public String getId() {
        return "thunderdome";
    }

    @Override
    public void run() {
        if (this.ticks == 0) {
            WorldInfo info = this.world.func_72912_H();
            info.func_176142_i(0);
            info.func_76084_b(true);
            info.func_76069_a(true);
            info.func_76090_f(400);
            info.func_76080_g(400);
        }
        ++this.ticks;
        if (this.ticks % 300 == 0) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            if (rand.nextInt(1, 100) < 22) {
                int randomX = this.pos.func_177958_n() + rand.nextInt(-5, 5);
                int randomY = this.pos.func_177956_o() + rand.nextInt(0, 1);
                int randomZ = this.pos.func_177952_p() + rand.nextInt(-5, 5);
                if (rand.nextInt(1, 100) < 33) {
                    EntityCreeper creeper = new EntityCreeper(this.world);
                    creeper.func_70012_b((double)randomX, (double)randomY, (double)randomZ, 0.0f, 0.0f);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag = creeper.func_189511_e(tag);
                    tag.func_74757_a("powered", true);
                    creeper.func_70037_a(tag);
                    this.world.func_72838_d((Entity)creeper);
                } else {
                    EntityWitch witch = new EntityWitch(this.world);
                    witch.func_70012_b((double)randomX, (double)randomY, (double)randomZ, 0.0f, 0.0f);
                    this.world.func_72838_d((Entity)witch);
                }
            }
            this.ticks = 0;
        }
    }

    @Override
    public void cleanUp() {
        WorldInfo info = this.world.func_72912_H();
        info.func_176142_i(0);
        info.func_76084_b(this.wasRaining);
        info.func_76069_a(this.wasThundering);
    }

    @Override
    public String getAffixName() {
        return TextFormatting.BLUE + I18n.func_135052_a((String)"deepmoblearning.affix.thunderdome.name", (Object[])new Object[0]) + TextFormatting.RESET;
    }
}

