/*
 * Decompiled with CFR 0.152.
 */
package mustapelto.deepmoblearning.common.util;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound result;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((result = stack.func_77978_p()) == null) {
            throw new NullPointerException("ItemStack NBTTagCompound is null when it shouldn't be");
        }
        return result;
    }

    @Nullable
    public static NBTTagCompound getTag(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p() : null;
    }

    public static boolean hasKey(ItemStack stack, String key) {
        NBTTagCompound nbt = NBTHelper.getTag(stack);
        return nbt != null && nbt.func_74764_b(key);
    }

    public static void removeKey(ItemStack stack, String key) {
        NBTTagCompound nbt = NBTHelper.getTag(stack);
        if (nbt == null) {
            return;
        }
        nbt.func_82580_o(key);
        if (nbt.func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    public static void setInteger(ItemStack stack, String key, int value) {
        NBTTagCompound nbt = NBTHelper.getOrCreateTag(stack);
        nbt.func_74768_a(key, value);
    }

    public static int getInteger(ItemStack stack, String key, int defaultValue) {
        NBTTagCompound nbt = NBTHelper.getTag(stack);
        return nbt != null ? NBTHelper.getInteger(nbt, key, defaultValue) : defaultValue;
    }

    public static int getInteger(ItemStack stack, String key) {
        return NBTHelper.getInteger(stack, key, 0);
    }

    public static void setString(ItemStack stack, String key, String value) {
        NBTTagCompound nbt = NBTHelper.getOrCreateTag(stack);
        nbt.func_74778_a(key, value);
    }

    public static String getString(ItemStack stack, String key, String defaultValue) {
        NBTTagCompound nbt = NBTHelper.getTag(stack);
        return nbt != null ? NBTHelper.getString(nbt, key, defaultValue) : defaultValue;
    }

    public static String getString(ItemStack stack, String key) {
        return NBTHelper.getString(stack, key, "");
    }

    public static NBTTagList getTagList(ItemStack stack, String key) {
        NBTTagCompound nbt = NBTHelper.getTag(stack);
        return nbt != null ? nbt.func_150295_c(key, 10) : new NBTTagList();
    }

    public static void setTagList(ItemStack stack, String key, NBTTagList list) {
        NBTTagCompound nbt = NBTHelper.getOrCreateTag(stack);
        nbt.func_74782_a(key, (NBTBase)list);
    }

    public static int getInteger(NBTTagCompound compound, String key, int defaultValue) {
        return compound.func_150297_b(key, 3) ? compound.func_74762_e(key) : defaultValue;
    }

    public static int getInteger(NBTTagCompound compound, String key) {
        return NBTHelper.getInteger(compound, key, 0);
    }

    public static boolean getBoolean(NBTTagCompound compound, String key, boolean defaultValue) {
        return compound.func_150297_b(key, 1) ? compound.func_74767_n(key) : defaultValue;
    }

    public static boolean getBoolean(NBTTagCompound compound, String key) {
        return NBTHelper.getBoolean(compound, key, false);
    }

    public static String getString(NBTTagCompound compound, String key, String defaultValue) {
        return compound.func_150297_b(key, 8) ? compound.func_74779_i(key) : defaultValue;
    }

    public static String getString(NBTTagCompound compound, String key) {
        return NBTHelper.getString(compound, key, "");
    }
}

