/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.container;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.slot.SlotFalseCopy;
import thelm.packagedauto.tile.TileBase;

public class ContainerTileBase<TILE extends TileBase>
extends Container {
    public final TILE tile;
    public final InventoryPlayer playerInventory;
    public final InventoryTileBase inventory;
    public final Int2IntMap prevSyncValues = new Int2IntRBTreeMap();

    public ContainerTileBase(InventoryPlayer playerInventory, TILE tile) {
        this.tile = tile;
        this.playerInventory = playerInventory;
        this.inventory = tile != null ? ((TileBase)tile).getInventory() : new InventoryTileBase(null, 0);
    }

    public int getPlayerInvY() {
        return 84;
    }

    public int getPlayerInvX() {
        return 8;
    }

    public void setupPlayerInventory() {
        int i;
        int xOffset = this.getPlayerInvX();
        int yOffset = this.getPlayerInvY();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public int getSizeInventory() {
        return this.inventory.func_70302_i_();
    }

    public boolean supportsShiftClick(EntityPlayer player, int slotIndex) {
        return true;
    }

    public boolean performMerge(EntityPlayer player, int slotIndex, ItemStack stack) {
        int invBase = this.getSizeInventory();
        int invFull = this.field_75151_b.size();
        if (slotIndex < invBase) {
            return this.func_75135_a(stack, invBase, invFull, true);
        }
        return this.func_75135_a(stack, 0, invBase, false);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (!this.supportsShiftClick(player, slotIndex)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (!this.performMerge(player, slotIndex, stackInSlot)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stackInSlot, stack);
            if (stackInSlot.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(stackInSlot);
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = !ascending ? slotMin : slotMax - 1;
        int n = iterOrder = !ascending ? 1 : -1;
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.field_75151_b.get(i);
                if (slot instanceof SlotFalseCopy) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.func_75211_c();
                if (!existingStack.func_190926_b() && slot.func_75214_a(MiscUtil.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.func_190916_E()))) && existingStack.func_77973_b().equals(stack.func_77973_b()) && (!stack.func_77981_g() || stack.func_77952_i() == existingStack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.func_190916_E() + stack.func_190916_E();
                    if (existingSize <= maxStack) {
                        stack.func_190920_e(0);
                        existingStack.func_190920_e(existingSize);
                        slot.func_75215_d(existingStack);
                        successful = true;
                    } else if (existingStack.func_190916_E() < maxStack) {
                        stack.func_190918_g(maxStack - existingStack.func_190916_E());
                        existingStack.func_190920_e(maxStack);
                        slot.func_75215_d(existingStack);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (stack.func_190916_E() > 0) {
            int n2 = i = !ascending ? slotMin : slotMax - 1;
            while (stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.field_75151_b.get(i);
                if (slot instanceof SlotFalseCopy) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.func_75211_c();
                if (existingStack.func_190926_b() && slot.func_75214_a(MiscUtil.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.func_190916_E())))) {
                    existingStack = stack.func_77979_a(rmv);
                    slot.func_75215_d(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, EntityPlayer player) {
        Slot slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (!(slot instanceof SlotFalseCopy)) return super.func_184996_a(slotId, mouseButton, clickType, player);
        ItemStack stack = slot.func_75211_c().func_77946_l();
        switch (mouseButton) {
            case 0: {
                slot.func_75215_d(player.field_71071_by.func_70445_o().func_190926_b() ? ItemStack.field_190927_a : player.field_71071_by.func_70445_o().func_77946_l());
                break;
            }
            case 1: {
                if (!player.field_71071_by.func_70445_o().func_190926_b()) {
                    ItemStack toPut = player.field_71071_by.func_70445_o().func_77946_l();
                    if (stack.func_77973_b() == toPut.func_77973_b() && stack.func_77952_i() == toPut.func_77952_i() && ItemStack.areItemStackShareTagsEqual((ItemStack)stack, (ItemStack)toPut) && stack.func_190916_E() < stack.func_77976_d()) {
                        stack.func_190917_f(1);
                        slot.func_75215_d(stack);
                        break;
                    }
                    toPut.func_190920_e(1);
                    slot.func_75215_d(toPut);
                    break;
                }
                if (stack.func_190926_b()) return player.field_71071_by.func_70445_o();
                stack.func_190918_g(1);
                slot.func_75215_d(stack);
                break;
            }
            case 2: {
                if (player.field_71075_bZ.field_75098_d) {
                    return super.func_184996_a(slotId, mouseButton, clickType, player);
                }
                if (stack.func_190926_b()) return player.field_71071_by.func_70445_o();
                if (stack.func_190916_E() >= stack.func_77976_d()) return player.field_71071_by.func_70445_o();
                stack.func_190917_f(1);
                slot.func_75215_d(stack);
            }
        }
        return player.field_71071_by.func_70445_o();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            for (int i = 0; i < this.inventory.func_174890_g(); ++i) {
                if (this.prevSyncValues.containsKey(i) && this.prevSyncValues.get(i) == this.inventory.func_174887_a_(i)) continue;
                listener.func_71112_a((Container)this, i, this.inventory.func_174887_a_(i));
            }
        }
        for (int i = 0; i < this.inventory.func_174890_g(); ++i) {
            this.prevSyncValues.put(i, this.inventory.func_174887_a_(i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        this.inventory.func_174885_b(id, data);
    }
}

