/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.RecipeTypeRegistry;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.recipe.RecipeTypeProcessing;
import thelm.packagedauto.tile.TileEncoder;

public class InventoryEncoderPattern
extends InventoryTileBase {
    public final TileEncoder tile;
    public IRecipeType recipeType;
    public IRecipeInfo recipeInfo;

    public InventoryEncoderPattern(TileEncoder tile) {
        super(tile, 99);
        this.tile = tile;
        this.validateRecipeType();
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.updateRecipeInfo(true);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.recipeType = RecipeTypeRegistry.getRecipeType(new ResourceLocation(nbt.func_74779_i("RecipeType")));
        this.validateRecipeType();
        this.updateRecipeInfo(false);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.validateRecipeType();
        nbt.func_74778_a("RecipeType", this.recipeType.getName().toString());
        return nbt;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        this.validateRecipeType();
        if (index < 81 || this.recipeType.canSetOutput() && index < 90) {
            return this.recipeType.getEnabledSlots().contains(index);
        }
        return false;
    }

    public void validateRecipeType() {
        if (this.recipeType == null) {
            this.recipeType = RecipeTypeProcessing.INSTANCE;
        }
    }

    public void updateRecipeInfo(boolean mark) {
        this.validateRecipeType();
        IRecipeInfo info = this.recipeType.getNewRecipeInfo();
        try {
            info.generateFromStacks(this.stacks.subList(0, 81), this.recipeType.canSetOutput() ? this.stacks.subList(81, 90) : Collections.emptyList(), this.tile.func_145831_w());
        }
        catch (AbstractMethodError error) {
            try {
                Method oldGenerateFromStacksMethod = info.getClass().getMethod("generateFromStacks", List.class, List.class);
                oldGenerateFromStacksMethod.invoke((Object)info, this.stacks.subList(0, 81), this.recipeType.canSetOutput() ? this.stacks.subList(81, 90) : Collections.emptyList());
            }
            catch (Exception exception) {
                exception.addSuppressed(error);
                exception.printStackTrace();
            }
        }
        if (info.isValid()) {
            if (this.recipeInfo == null || !this.recipeInfo.equals(info)) {
                this.recipeInfo = info;
                if (!this.recipeType.canSetOutput()) {
                    for (int i = 81; i < 90; ++i) {
                        this.stacks.set(i, (Object)ItemStack.field_190927_a);
                    }
                    List<ItemStack> outputs = info.getOutputs();
                    int size = outputs.size();
                    int startIndex = 81;
                    switch (size) {
                        case 1: {
                            ++startIndex;
                        }
                        case 2: 
                        case 3: {
                            startIndex += 3;
                        }
                    }
                    for (int i = 0; i < size; ++i) {
                        this.stacks.set(startIndex + i, (Object)outputs.get(i).func_77946_l());
                    }
                }
                for (int i = 90; i < 99; ++i) {
                    this.stacks.set(i, (Object)ItemStack.field_190927_a);
                }
                List<IPackagePattern> patterns = info.getPatterns();
                for (int i = 0; i < patterns.size() && i < 9; ++i) {
                    this.stacks.set(90 + i, (Object)patterns.get(i).getOutput().func_77946_l());
                }
                if (mark) {
                    this.syncTile(false);
                    this.func_70296_d();
                }
            }
        } else if (this.recipeInfo != null) {
            this.recipeInfo = null;
            if (!this.recipeType.canSetOutput()) {
                for (int i = 81; i < 90; ++i) {
                    this.stacks.set(i, (Object)ItemStack.field_190927_a);
                }
            }
            for (int i = 90; i < 99; ++i) {
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
            }
            if (mark) {
                this.syncTile(false);
                this.func_70296_d();
            }
        }
    }

    public void cycleRecipeType(boolean reverse) {
        this.validateRecipeType();
        this.recipeType = RecipeTypeRegistry.getNextRecipeType(this.recipeType, reverse);
        this.validateRecipeType();
        IntSet enabledSlots = this.recipeType.getEnabledSlots();
        for (int i = 0; i < 90; ++i) {
            if (enabledSlots.contains(i)) continue;
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.updateRecipeInfo(true);
        for (InventoryEncoderPattern patternInventory : this.tile.patternInventories) {
            if (patternInventory == this) continue;
            patternInventory.setRecipeTypeIfEmpty(this.recipeType);
        }
    }

    public void setRecipeTypeIfEmpty(IRecipeType recipeType) {
        if (this.stacks.stream().allMatch(ItemStack::func_190926_b)) {
            this.recipeType = recipeType;
            this.validateRecipeType();
            this.updateRecipeInfo(true);
        }
    }

    public void setRecipe(Int2ObjectMap<ItemStack> map) {
        int i;
        if (this.recipeType.canSetOutput()) {
            for (i = 0; i < 90; ++i) {
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
            }
        } else {
            for (i = 0; i < 81; ++i) {
                this.stacks.set(i, (Object)ItemStack.field_190927_a);
            }
        }
        if (map != null) {
            for (Int2ObjectMap.Entry entry : map.int2ObjectEntrySet()) {
                this.stacks.set(entry.getIntKey(), entry.getValue());
            }
        }
        this.updateRecipeInfo(true);
    }
}

