/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IWorldNameable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.client.gui.IGuiProvider;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.InventoryTileBase;

public abstract class TileBase
extends TileEntity
implements IWorldNameable,
IGuiProvider {
    protected InventoryTileBase inventory = new InventoryTileBase(this, 0);
    protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
    public String customName = "";
    protected UUID ownerUUID = null;
    @Deprecated
    protected int placerID = -1;

    public InventoryTileBase getInventory() {
        return this.inventory;
    }

    public void setInventory(InventoryTileBase inventory) {
        this.inventory = inventory;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public void setEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public void setOwner(EntityPlayer owner) {
        this.ownerUUID = owner.func_110124_au();
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    protected abstract String getLocalizedName();

    public String func_70005_c_() {
        return this.customName.isEmpty() ? this.getLocalizedName() : this.customName;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_145818_k_() {
        return !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        if (!name.isEmpty()) {
            this.customName = name;
        }
    }

    public int getComparatorSignal() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.inventory.getWrapperForDirection(null));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readSyncNBT(nbt);
        this.inventory.readFromNBT(nbt);
        this.ownerUUID = null;
        if (nbt.func_186855_b("OwnerUUID")) {
            this.ownerUUID = nbt.func_186857_a("OwnerUUID");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeSyncNBT(nbt);
        this.inventory.writeToNBT(nbt);
        if (this.ownerUUID != null) {
            nbt.func_186854_a("OwnerUUID", this.ownerUUID);
        }
        return nbt;
    }

    public void readSyncNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Name")) {
            this.customName = nbt.func_74779_i("Name");
        }
        this.energyStorage.readFromNBT(nbt);
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbt) {
        if (!this.customName.isEmpty()) {
            nbt.func_74778_a("Name", this.customName);
        }
        this.energyStorage.writeToNBT(nbt);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncNBT(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -10, this.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.readSyncNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_82580_o("ForgeData");
        nbt.func_82580_o("ForgeCaps");
        this.writeSyncNBT(nbt);
        return nbt;
    }

    public void syncTile(boolean rerender) {
        if (this.field_145850_b != null && this.field_145850_b.func_175667_e(this.field_174879_c)) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2 + (rerender ? 4 : 0));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY && this.energyStorage.getMaxEnergyStored() > 0 || super.hasCapability(capability, from);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getWrapperForDirection(facing);
        }
        if (capability == CapabilityEnergy.ENERGY && this.energyStorage.getMaxEnergyStored() > 0) {
            return (T)((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }
}

